/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.filter.IPrediction;
import java.io.IOException;

public abstract class Prediction
implements IPrediction {
    public static final COSName DK_BitsPerComponent = COSName.constant("BitsPerComponent");
    public static final COSName DK_Colors = COSName.constant("Colors");
    public static final COSName DK_Columns = COSName.constant("Columns");
    public static final COSName DK_Predictor = COSName.constant("Predictor");
    public static final int None = 1;
    public static final int PNGAverage = 13;
    public static final int PNGNone = 10;
    public static final int PNGOptimum = 15;
    public static final int PNGPaeth = 14;
    public static final int PNGSub = 11;
    public static final int PNGUp = 12;
    public static final int TIFF = 2;
    private int bitsPerComponent;
    private int colors;
    private int columns;
    private int resultRowSize;
    private int sourceRowSize;

    public Prediction(COSDictionary cOSDictionary) {
        COSInteger cOSInteger = cOSDictionary.get(DK_BitsPerComponent).asInteger();
        this.bitsPerComponent = cOSInteger == null ? 8 : cOSInteger.intValue();
        cOSInteger = cOSDictionary.get(DK_Colors).asInteger();
        this.colors = cOSInteger == null ? 1 : cOSInteger.intValue();
        cOSInteger = cOSDictionary.get(DK_Columns).asInteger();
        this.columns = cOSInteger == null ? 1 : cOSInteger.intValue();
        this.resultRowSize = this.computeResultRowSize();
        this.sourceRowSize = this.computeSourceRowSize();
    }

    public int computeResultRowSize() {
        return (int)Math.ceil((double)this.colors * (double)this.columns / (double)(8 / this.bitsPerComponent));
    }

    public int computeSourceRowSize() {
        return this.computeResultRowSize();
    }

    @Override
    public byte[] decode(byte[] byArray) throws IOException {
        int n = byArray.length / this.sourceRowSize;
        byte[] byArray2 = new byte[n * this.resultRowSize];
        int n2 = 0;
        while (n2 < n) {
            this.decodeRow(byArray, this.sourceRowSize * n2, byArray2, this.resultRowSize * n2);
            ++n2;
        }
        return byArray2;
    }

    protected abstract void decodeRow(byte[] var1, int var2, byte[] var3, int var4) throws IOException;

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public int getColors() {
        return this.colors;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getResultRowSize() {
        return this.resultRowSize;
    }

    public int getSourceRowSize() {
        return this.sourceRowSize;
    }
}

