/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDForm;
import java.util.HashSet;

public class PDAppearanceTools {
    protected static PDForm createAppearanceForm() {
        PDForm form = (PDForm)PDForm.META.createNew();
        return form;
    }

    public static boolean createState(PDAppearance appearance, String state) {
        COSName[] keys;
        boolean result = false;
        COSName cosState = COSName.create(state);
        COSName[] cOSNameArray = keys = new COSName[]{PDAppearance.DK_N, PDAppearance.DK_R, PDAppearance.DK_D};
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            COSObject form;
            COSName key = cOSNameArray[n2];
            COSDictionary dict = appearance.cosGetDict().get(key).asDictionary();
            if (dict != null && (form = dict.get(cosState)).isNull()) {
                dict.put(cosState, PDAppearanceTools.createAppearanceForm().cosGetObject());
                result = true;
            }
            ++n2;
        }
        return result;
    }

    public static PDForm getDownAppearance(PDAppearance appearance, COSName state) {
        PDForm form = appearance.getDownAppearance(state);
        if (form == null) {
            form = PDAppearanceTools.createAppearanceForm();
            appearance.setDownAppearance(state, form);
        }
        return form;
    }

    public static PDForm getNormalAppearance(PDAppearance appearance, COSName state) {
        PDForm form = appearance.getNormalAppearance(state);
        if (form == null) {
            form = PDAppearanceTools.createAppearanceForm();
            appearance.setNormalAppearance(state, form);
        }
        return form;
    }

    public static PDForm getRolloverAppearance(PDAppearance appearance, COSName state) {
        PDForm form = appearance.getRolloverAppearance(state);
        if (form == null) {
            form = PDAppearanceTools.createAppearanceForm();
            appearance.setRolloverAppearance(state, form);
        }
        return form;
    }

    public static void renameState(PDAppearance appearance, String oldState, String newState) {
        COSName[] keys;
        COSName cosOldState = COSName.create(oldState);
        COSName cosNewState = COSName.create(newState);
        COSName[] cOSNameArray = keys = new COSName[]{PDAppearance.DK_N, PDAppearance.DK_R, PDAppearance.DK_D};
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            COSObject form;
            COSName key = cOSNameArray[n2];
            COSDictionary dict = appearance.cosGetDict().get(key).asDictionary();
            if (dict != null && !(form = dict.get(cosOldState)).isNull()) {
                dict.remove(cosOldState);
                dict.put(cosNewState, form);
            }
            ++n2;
        }
    }

    public static void resetAppearance(COSDictionary appearanceDict) {
        if (appearanceDict == null) {
            return;
        }
        for (COSName appKey : new HashSet(appearanceDict.keySet())) {
            COSObject appValue = appearanceDict.get(appKey);
            if (appValue instanceof COSDictionary) {
                COSDictionary appValueDict = (COSDictionary)appValue;
                for (COSName stateKey : new HashSet(appValueDict.keySet())) {
                    appValueDict.put(stateKey, PDForm.META.createNew().cosGetObject());
                }
                continue;
            }
            appearanceDict.put(appKey, PDForm.META.createNew().cosGetObject());
        }
    }

    public static void resetAppearance(PDAppearance appearance) {
        PDAppearanceTools.resetAppearance(appearance.cosGetDict());
    }
}

