/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyInstance
implements Serializable {
    private static final long serialVersionUID = -1275072482996745126L;
    private final Logger logger = LoggerFactory.getLogger(GroovyInstance.class);
    private static final int DEFAULT_REFRESH_INTERVAL = 2000;
    private String groovyFileName;
    private int refreshInterval = 2000;
    private transient Class instanceClass;
    private transient Object instance;
    private transient long lastRefresh;
    private transient long previousFileTimestamp;
    private transient long previousFileSize;
    private transient String errorMessage;
    private transient Throwable errorCause;
    private transient Class actualInstanceClass;

    public String getGroovyFileName() {
        return this.groovyFileName;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        if (refreshInterval < 0) {
            throw new IllegalArgumentException("refreshInterval must not be negative!");
        }
        this.refreshInterval = refreshInterval;
    }

    public void setGroovyFileName(String groovyFileName) {
        if (groovyFileName == null || !groovyFileName.equals(this.groovyFileName)) {
            this.groovyFileName = groovyFileName;
            this.lastRefresh = -1L;
            this.previousFileTimestamp = -1L;
            this.previousFileSize = -1L;
            this.instanceClass = null;
            this.instance = null;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }

    private void initInstanceClass() {
        long current = System.currentTimeMillis();
        if (this.instanceClass != null && current - this.lastRefresh < (long)this.refreshInterval) {
            return;
        }
        if (this.groovyFileName == null) {
            this.handleError("groovyFileName must not be null!", null);
            return;
        }
        this.lastRefresh = current;
        File groovyFile = new File(this.groovyFileName);
        if (!groovyFile.isFile()) {
            this.handleError("'" + groovyFile.getAbsolutePath() + "' is not a file!", null);
            return;
        }
        if (!groovyFile.canRead()) {
            this.handleError("'" + groovyFile.getAbsolutePath() + "' can not be read!", null);
            return;
        }
        long fileTimestamp = groovyFile.lastModified();
        long fileSize = groovyFile.length();
        if (this.previousFileTimestamp != fileTimestamp || this.previousFileSize != fileSize) {
            GroovyClassLoader gcl = new GroovyClassLoader();
            gcl.setShouldRecompile(Boolean.valueOf(true));
            try {
                this.previousFileTimestamp = fileTimestamp;
                this.previousFileSize = fileSize;
                this.instanceClass = gcl.parseClass(groovyFile);
                this.instance = null;
                this.errorMessage = null;
                this.errorCause = null;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Parsed class {} from '{}'.", (Object)this.instanceClass.getName(), (Object)groovyFile.getAbsolutePath());
                }
            }
            catch (Throwable e) {
                this.handleError("Exception while parsing class from '" + groovyFile.getAbsolutePath() + "'!", e);
            }
        }
    }

    private void initInstance() {
        long current = System.currentTimeMillis();
        if (this.instance != null && current - this.lastRefresh < (long)this.refreshInterval) {
            return;
        }
        this.initInstanceClass();
        if (this.actualInstanceClass == this.instanceClass) {
            return;
        }
        this.instance = null;
        if (this.instanceClass != null) {
            this.actualInstanceClass = this.instanceClass;
            try {
                this.instance = this.instanceClass.newInstance();
                this.errorMessage = null;
                this.errorCause = null;
            }
            catch (Throwable e) {
                this.handleError("Exception while creating instance of '" + this.instanceClass.getName() + "'!", e);
            }
        }
    }

    public Class getInstanceClass() {
        this.initInstanceClass();
        return this.instanceClass;
    }

    public Object getInstance() {
        this.initInstance();
        return this.instance;
    }

    public <T> T getInstanceAs(Class<T> iface) {
        Object theInstance = this.getInstance();
        if (iface.isInstance(theInstance)) {
            return iface.cast(theInstance);
        }
        return null;
    }

    public Object getNewInstance() {
        this.initInstanceClass();
        if (this.instanceClass != null) {
            try {
                return this.instanceClass.newInstance();
            }
            catch (Throwable e) {
                this.handleError("Exception while creating instance of '" + this.instanceClass.getName() + "'!", e);
            }
        }
        return null;
    }

    public <T> T getNewInstanceAs(Class<T> iface) {
        Object theInstance = this.getNewInstance();
        if (iface.isInstance(theInstance)) {
            return iface.cast(theInstance);
        }
        return null;
    }

    private void handleError(String message, Throwable throwable) {
        this.errorMessage = message;
        this.errorCause = throwable;
        this.instanceClass = null;
        this.instance = null;
        if (this.logger.isWarnEnabled()) {
            if (throwable != null) {
                this.logger.warn(message, throwable);
            } else {
                this.logger.warn(message);
            }
        }
    }
}

