/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.json.LoggingModule;
import de.huxhorn.sulky.codec.Decoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingJsonDecoder
implements Decoder<LoggingEvent> {
    private boolean compressing;
    private ObjectMapper mapper;

    public LoggingJsonDecoder(boolean compressing) {
        this.compressing = compressing;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new LoggingModule());
        this.mapper.registerModule((Module)new AfterburnerModule());
    }

    public LoggingEvent decode(byte[] bytes) {
        try {
            if (this.compressing) {
                return (LoggingEvent)this.mapper.readValue((InputStream)new GZIPInputStream(new ByteArrayInputStream(bytes)), LoggingEvent.class);
            }
            return (LoggingEvent)this.mapper.readValue((InputStream)new ByteArrayInputStream(bytes), LoggingEvent.class);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

