/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jbehave.junit.monitoring;

import de.codecentric.jbehave.junit.monitoring.JUnitDescriptionGenerator;
import de.codecentric.jbehave.junit.monitoring.JUnitScenarioReporter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.StoryRunner;
import org.jbehave.core.io.StoryPathResolver;
import org.jbehave.core.junit.JUnitStories;
import org.jbehave.core.junit.JUnitStory;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.NullStepMonitor;
import org.jbehave.core.steps.StepMonitor;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.Statement;

public class JUnitReportingRunner
extends BlockJUnit4ClassRunner {
    private List<Description> storyDescriptions;
    private Embedder configuredEmbedder;
    private List<String> storyPaths;
    private Configuration configuration;
    private int numberOfTestCases;
    private Description rootDescription;
    List<CandidateSteps> candidateSteps;
    private ConfigurableEmbedder configurableEmbedder;

    public JUnitReportingRunner(Class<? extends ConfigurableEmbedder> testClass) throws Throwable {
        super(testClass);
        this.configurableEmbedder = testClass.newInstance();
        if (this.configurableEmbedder instanceof JUnitStories) {
            this.getStoryPathsFromJUnitStories(testClass);
        } else if (this.configurableEmbedder instanceof JUnitStory) {
            this.getStoryPathsFromJUnitStory();
        }
        this.configuration = this.configuredEmbedder.configuration();
        StepMonitor originalStepMonitor = this.createCandidateStepsWithNoMonitor();
        this.storyDescriptions = this.buildDescriptionFromStories();
        this.createCandidateStepsWith(originalStepMonitor);
        this.initRootDescription();
    }

    public Description getDescription() {
        return this.rootDescription;
    }

    public int testCount() {
        return this.numberOfTestCases;
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                JUnitScenarioReporter junitReporter = new JUnitScenarioReporter(notifier, JUnitReportingRunner.this.numberOfTestCases, JUnitReportingRunner.this.rootDescription, JUnitReportingRunner.this.configuration.keywords());
                junitReporter.usePendingStepStrategy(JUnitReportingRunner.this.configuration.pendingStepStrategy());
                JUnitReportingRunner.this.addToStoryReporterFormats(junitReporter);
                try {
                    JUnitReportingRunner.this.configuredEmbedder.runStoriesAsPaths(JUnitReportingRunner.this.storyPaths);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                finally {
                    JUnitReportingRunner.this.configuredEmbedder.generateCrossReference();
                }
            }
        };
    }

    public static EmbedderControls recommandedControls(Embedder embedder) {
        return JUnitReportingRunner.recommendedControls(embedder);
    }

    public static EmbedderControls recommendedControls(Embedder embedder) {
        return embedder.embedderControls().doIgnoreFailureInView(true).doIgnoreFailureInStories(true).useThreads(1);
    }

    private void createCandidateStepsWith(StepMonitor stepMonitor) {
        this.configuration.useStepMonitor(stepMonitor);
        this.getCandidateSteps();
        for (CandidateSteps step : this.candidateSteps) {
            step.configuration().useStepMonitor(stepMonitor);
        }
    }

    private StepMonitor createCandidateStepsWithNoMonitor() {
        StepMonitor usedStepMonitor = this.configuration.stepMonitor();
        this.createCandidateStepsWith((StepMonitor)new NullStepMonitor());
        return usedStepMonitor;
    }

    private void getStoryPathsFromJUnitStory() {
        this.configuredEmbedder = this.configurableEmbedder.configuredEmbedder();
        StoryPathResolver resolver = this.configuredEmbedder.configuration().storyPathResolver();
        this.storyPaths = Arrays.asList(resolver.resolve(this.configurableEmbedder.getClass()));
    }

    private void getStoryPathsFromJUnitStories(Class<? extends ConfigurableEmbedder> testClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.configuredEmbedder = this.configurableEmbedder.configuredEmbedder();
        Method method = this.makeStoryPathsMethodPublic(testClass);
        this.storyPaths = (List)method.invoke((Object)((JUnitStories)this.configurableEmbedder), (Object[])null);
    }

    private Method makeStoryPathsMethodPublic(Class<? extends ConfigurableEmbedder> testClass) throws NoSuchMethodException {
        Method method;
        try {
            method = testClass.getDeclaredMethod("storyPaths", null);
        }
        catch (NoSuchMethodException e) {
            method = testClass.getMethod("storyPaths", null);
        }
        method.setAccessible(true);
        return method;
    }

    private void getCandidateSteps() {
        InjectableStepsFactory stepsFactory = this.configurableEmbedder.stepsFactory();
        if (stepsFactory != null) {
            this.candidateSteps = stepsFactory.createCandidateSteps();
        } else {
            Embedder embedder = this.configurableEmbedder.configuredEmbedder();
            this.candidateSteps = embedder.candidateSteps();
            if (this.candidateSteps == null || this.candidateSteps.isEmpty()) {
                this.candidateSteps = embedder.stepsFactory().createCandidateSteps();
            }
        }
    }

    private void initRootDescription() {
        this.rootDescription = Description.createSuiteDescription(this.configurableEmbedder.getClass());
        for (Description storyDescription : this.storyDescriptions) {
            this.rootDescription.addChild(storyDescription);
        }
    }

    private void addToStoryReporterFormats(JUnitScenarioReporter junitReporter) {
        StoryReporterBuilder storyReporterBuilder = this.configuration.storyReporterBuilder();
        StoryReporterBuilder.ProvidedFormat junitReportFormat = new StoryReporterBuilder.ProvidedFormat((StoryReporter)junitReporter);
        storyReporterBuilder.withFormats(new Format[]{junitReportFormat});
    }

    private List<Description> buildDescriptionFromStories() {
        JUnitDescriptionGenerator descriptionGenerator = new JUnitDescriptionGenerator(this.candidateSteps, this.configuration);
        StoryRunner storyRunner = new StoryRunner();
        ArrayList<Description> storyDescriptions = new ArrayList<Description>();
        this.addSuite(storyDescriptions, "BeforeStories");
        this.addStories(storyDescriptions, storyRunner, descriptionGenerator);
        this.addSuite(storyDescriptions, "AfterStories");
        this.numberOfTestCases += descriptionGenerator.getTestCases();
        return storyDescriptions;
    }

    private void addStories(List<Description> storyDescriptions, StoryRunner storyRunner, JUnitDescriptionGenerator gen) {
        for (String storyPath : this.storyPaths) {
            Story parseStory = storyRunner.storyOfPath(this.configuration, storyPath);
            Description descr = gen.createDescriptionFrom(parseStory);
            storyDescriptions.add(descr);
        }
    }

    private void addSuite(List<Description> storyDescriptions, String name) {
        storyDescriptions.add(Description.createTestDescription(Object.class, (String)name));
        ++this.numberOfTestCases;
    }
}

