/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.injection;

import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.injection.InjectionTargetInformation;
import de.akquinet.jbosscc.needle.mock.MockProvider;

public class DefaultMockInjectionProvider
implements InjectionProvider<Object> {
    private final Class<?> type;
    private final MockProvider mockProvider;

    public DefaultMockInjectionProvider(Class<?> type, MockProvider mockProvider) {
        this.type = type;
        this.mockProvider = mockProvider;
    }

    @Override
    public Object getInjectedObject(Class<?> type) {
        return this.mockProvider.createMockComponent(type);
    }

    @Override
    public boolean verify(InjectionTargetInformation injectionTargetInformation) {
        return injectionTargetInformation.getType() == this.type || this.type.isAnnotation() && injectionTargetInformation.isAnnotationPresent(this.type);
    }

    protected Class<?> getType() {
        return this.type;
    }

    @Override
    public Object getKey(InjectionTargetInformation injectionTargetInformation) {
        return injectionTargetInformation.getType();
    }
}

