/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

public final class RSAPublicKeyCryptix
implements RSAPublicKey {
    private final BigInteger n;
    private final BigInteger e;

    public RSAPublicKeyCryptix(BigInteger n, BigInteger e) {
        this.n = n;
        this.e = e;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MPIOutputStream mos = new MPIOutputStream((OutputStream)baos);
            mos.write(this.n);
            mos.write(this.e);
            mos.flush();
            mos.close();
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("PANIC");
        }
    }

    public String getFormat() {
        return "Cryptix";
    }

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.e;
    }
}

