/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public final class IDEA
extends BlockCipher {
    private static final int ROUNDS = 8;
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 16;
    private static final int INTERNAL_KEY_LENGTH = 52;
    private short[] ks = new short[52];

    public IDEA() {
        super(8);
    }

    private void blockEncrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        short s2;
        short x1 = (short)((in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF);
        short x2 = (short)((in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF);
        short x3 = (short)((in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF);
        short x4 = (short)((in[inOffset++] & 0xFF) << 8 | in[inOffset] & 0xFF);
        int i = 0;
        int round = 8;
        while (round-- > 0) {
            x1 = IDEA.mul(x1, this.ks[i++]);
            x2 = (short)(x2 + this.ks[i++]);
            x3 = (short)(x3 + this.ks[i++]);
            x4 = IDEA.mul(x4, this.ks[i++]);
            short s3 = x3;
            x3 = IDEA.mul(x1 ^ x3, this.ks[i++]);
            s2 = x2;
            x2 = IDEA.mul(x3 + (x2 ^ x4), this.ks[i++]);
            x3 = (short)(x3 + x2);
            x1 = (short)(x1 ^ x2);
            x4 = (short)(x4 ^ x3);
            x2 = (short)(x2 ^ s3);
            x3 = (short)(x3 ^ s2);
        }
        s2 = IDEA.mul(x1, this.ks[i++]);
        out[outOffset++] = (byte)(s2 >>> 8);
        out[outOffset++] = (byte)s2;
        s2 = (short)(x3 + this.ks[i++]);
        out[outOffset++] = (byte)(s2 >>> 8);
        out[outOffset++] = (byte)s2;
        s2 = (short)(x2 + this.ks[i++]);
        out[outOffset++] = (byte)(s2 >>> 8);
        out[outOffset++] = (byte)s2;
        s2 = IDEA.mul(x4, this.ks[i]);
        out[outOffset++] = (byte)(s2 >>> 8);
        out[outOffset] = (byte)s2;
    }

    protected void coreCrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        this.blockEncrypt(in, inOffset, out, outOffset);
    }

    protected void coreInit(Key key, boolean decrypt) throws InvalidKeyException {
        this.makeKey(key);
        if (decrypt) {
            this.invertKey();
        }
    }

    private static short inv(short xx) {
        int x = xx & 0xFFFF;
        if (x <= 1) {
            return (short)x;
        }
        int t1 = 65537 / x;
        int y = 65537 % x;
        if (y == 1) {
            return (short)(1 - t1);
        }
        int t0 = 1;
        do {
            int q = x / y;
            t0 += q * t1;
            if ((x %= y) == 1) {
                return (short)t0;
            }
            q = y / x;
            t1 += q * t0;
        } while ((y %= x) != 1);
        return (short)(1 - t1);
    }

    private void invertKey() {
        int j = 4;
        int k = 51;
        short[] temp = new short[52];
        temp[k--] = IDEA.inv(this.ks[3]);
        temp[k--] = -this.ks[2];
        temp[k--] = -this.ks[1];
        temp[k--] = IDEA.inv(this.ks[0]);
        int i = 1;
        while (i < 8) {
            temp[k--] = this.ks[j + 1];
            temp[k--] = this.ks[j];
            temp[k--] = IDEA.inv(this.ks[j + 5]);
            temp[k--] = -this.ks[j + 3];
            temp[k--] = -this.ks[j + 4];
            temp[k--] = IDEA.inv(this.ks[j + 2]);
            ++i;
            j += 6;
        }
        temp[k--] = this.ks[j + 1];
        temp[k--] = this.ks[j];
        temp[k--] = IDEA.inv(this.ks[j + 5]);
        temp[k--] = -this.ks[j + 4];
        temp[k--] = -this.ks[j + 3];
        temp[k--] = IDEA.inv(this.ks[j + 2]);
        System.arraycopy(temp, 0, this.ks, 0, 52);
    }

    private void makeKey(Key key) throws InvalidKeyException {
        byte[] userkey = key.getEncoded();
        if (userkey == null) {
            throw new InvalidKeyException("Null user key");
        }
        if (userkey.length != 16) {
            throw new InvalidKeyException("Invalid user key length");
        }
        this.ks[0] = (short)((userkey[0] & 0xFF) << 8 | userkey[1] & 0xFF);
        this.ks[1] = (short)((userkey[2] & 0xFF) << 8 | userkey[3] & 0xFF);
        this.ks[2] = (short)((userkey[4] & 0xFF) << 8 | userkey[5] & 0xFF);
        this.ks[3] = (short)((userkey[6] & 0xFF) << 8 | userkey[7] & 0xFF);
        this.ks[4] = (short)((userkey[8] & 0xFF) << 8 | userkey[9] & 0xFF);
        this.ks[5] = (short)((userkey[10] & 0xFF) << 8 | userkey[11] & 0xFF);
        this.ks[6] = (short)((userkey[12] & 0xFF) << 8 | userkey[13] & 0xFF);
        this.ks[7] = (short)((userkey[14] & 0xFF) << 8 | userkey[15] & 0xFF);
        int i = 0;
        int zoff = 0;
        int j = 8;
        while (j < 52) {
            this.ks[++i + 7 + zoff] = (short)(this.ks[(i & 7) + zoff] << 9 | this.ks[(i + 1 & 7) + zoff] >>> 7 & 0x1FF);
            zoff += i & 8;
            i &= 7;
            ++j;
        }
    }

    private static short mul(int a, int b) {
        b &= 0xFFFF;
        if ((a &= 0xFFFF) != 0) {
            if (b != 0) {
                int p = a * b;
                return (short)(b - a + ((b = p & 0xFFFF) < (a = p >>> 16) ? 1 : 0));
            }
            return (short)(1 - a);
        }
        return (short)(1 - b);
    }
}

