/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jaxrs.config;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.config.FilterFactory;
import com.wordnik.swagger.config.SwaggerConfig;
import com.wordnik.swagger.core.filter.SwaggerSpecFilter;
import com.wordnik.swagger.models.Swagger;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectiveJaxrsScanner
implements SwaggerConfig,
com.wordnik.swagger.config.Scanner {
    Logger LOGGER = LoggerFactory.getLogger(ReflectiveJaxrsScanner.class);
    protected boolean prettyPrint = false;
    protected String resourcePackage = "";
    protected Reflections reflections;
    protected Set<String> acceptablePackages;
    protected String filterClass;

    public void setReflections(Reflections reflections) {
        this.reflections = reflections;
    }

    protected Reflections getReflections() {
        if (this.reflections == null) {
            ConfigurationBuilder config = new ConfigurationBuilder();
            this.acceptablePackages = new HashSet<String>();
            if (this.resourcePackage != "") {
                String[] parts;
                for (String pkg : parts = this.resourcePackage.split(",")) {
                    if ("".equals(pkg)) continue;
                    this.acceptablePackages.add(pkg);
                    config.addUrls(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0]));
                }
            }
            config.setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
            this.reflections = new Reflections((Configuration)config);
        }
        return this.reflections;
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public Swagger configure(Swagger swagger) {
        if (this.filterClass != null) {
            try {
                SwaggerSpecFilter filter = (SwaggerSpecFilter)Class.forName(this.filterClass).newInstance();
                if (filter != null) {
                    FilterFactory.setFilter((SwaggerSpecFilter)filter);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("failed to load filter", (Throwable)e);
            }
        }
        return swagger;
    }

    public Set<Class<?>> classes() {
        Set classes = this.getReflections().getTypesAnnotatedWith(Api.class);
        HashSet output = new HashSet();
        for (Class cls : classes) {
            if (!this.acceptablePackages.contains(cls.getPackage().getName())) continue;
            output.add(cls);
        }
        return output;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public boolean getPrettyPrint() {
        return true;
    }

    public void setPrettyPrint(boolean shouldPrettyPrint) {
        this.prettyPrint = shouldPrettyPrint;
    }
}

