/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jaxrs.config;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.config.FilterFactory;
import com.wordnik.swagger.config.ScannerFactory;
import com.wordnik.swagger.config.SwaggerConfig;
import com.wordnik.swagger.core.filter.SwaggerSpecFilter;
import com.wordnik.swagger.jaxrs.Reader;
import com.wordnik.swagger.jaxrs.config.AbstractScanner;
import com.wordnik.swagger.models.Contact;
import com.wordnik.swagger.models.Info;
import com.wordnik.swagger.models.License;
import com.wordnik.swagger.models.Scheme;
import com.wordnik.swagger.models.Swagger;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConfig
extends AbstractScanner
implements com.wordnik.swagger.config.Scanner,
SwaggerConfig {
    Logger LOGGER = LoggerFactory.getLogger(BeanConfig.class);
    Reader reader = new Reader(new Swagger());
    String resourcePackage;
    String[] schemes;
    String title;
    String version;
    String description;
    String termsOfServiceUrl;
    String contact;
    String license;
    String licenseUrl;
    String filterClass;
    Info info;
    String host;
    String basePath;

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public String[] getSchemes() {
        return this.schemes;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTermsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    public void setTermsOfServiceUrl(String termsOfServiceUrl) {
        this.termsOfServiceUrl = termsOfServiceUrl;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        if (!"".equals(basePath) && basePath != null) {
            this.basePath = !basePath.startsWith("/") ? "/" + basePath : basePath;
        }
    }

    public void setPrettyPrint(String prettyPrint) {
        if (prettyPrint != null) {
            this.prettyPrint = Boolean.parseBoolean(prettyPrint);
        }
    }

    public void setScan(boolean shouldScan) {
        Set<Class<?>> classes = this.classes();
        if (classes != null) {
            this.reader.read(classes).host(this.host).basePath(this.basePath).info(this.info);
        }
        ScannerFactory.setScanner(this);
    }

    public boolean getScan() {
        return true;
    }

    public Set<Class<?>> classes() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        HashSet<String> acceptablePackages = new HashSet<String>();
        if (this.resourcePackage != "") {
            String[] parts;
            for (String pkg : parts = this.resourcePackage.split(",")) {
                if ("".equals(pkg)) continue;
                acceptablePackages.add(pkg);
                config.addUrls(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0]));
            }
        }
        config.setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
        this.info = new Info().description(this.description).title(this.title).version(this.version).termsOfService(this.termsOfServiceUrl);
        if (this.contact != null) {
            this.info.contact(new Contact().name(this.contact));
        }
        if (this.license != null && this.licenseUrl != null) {
            this.info.license(new License().name(this.license).url(this.licenseUrl));
        }
        if (this.schemes != null) {
            for (String scheme : this.schemes) {
                this.reader.getSwagger().scheme(Scheme.forValue((String)scheme));
            }
        }
        this.reader.getSwagger().setInfo(this.info);
        Set classes = new Reflections((Configuration)config).getTypesAnnotatedWith(Api.class);
        HashSet output = new HashSet();
        for (Class cls : classes) {
            if (!acceptablePackages.contains(cls.getPackage().getName())) continue;
            output.add(cls);
        }
        return output;
    }

    public Swagger getSwagger() {
        return this.reader.getSwagger();
    }

    public Swagger configure(Swagger swagger) {
        if (this.schemes != null) {
            for (String scheme : this.schemes) {
                swagger.scheme(Scheme.forValue((String)scheme));
            }
        }
        if (this.filterClass != null) {
            try {
                SwaggerSpecFilter filter = (SwaggerSpecFilter)Class.forName(this.filterClass).newInstance();
                if (filter != null) {
                    FilterFactory.setFilter((SwaggerSpecFilter)filter);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("failed to load filter", (Throwable)e);
            }
        }
        return swagger.info(this.info).host(this.host).basePath(this.basePath);
    }
}

