/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.MapProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.PropertyBuilder;
import com.wordnik.swagger.models.properties.RefProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDeserializer
extends JsonDeserializer<Property> {
    Logger LOGGER = LoggerFactory.getLogger(PropertyDeserializer.class);

    public Property deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return this.propertyFromNode(node);
    }

    Property propertyFromNode(JsonNode node) {
        Property items;
        Property output;
        Property _enum = null;
        String type = null;
        String format = null;
        String title = null;
        String description = null;
        String _default = null;
        String pattern = null;
        String discriminator = null;
        Integer minItems = null;
        Integer maxItems = null;
        Integer minProperties = null;
        Integer maxProperties = null;
        Integer maxLength = null;
        Integer minLength = null;
        Double minimum = null;
        Double maximum = null;
        Double exclusiveMinimum = null;
        Double exclusiveMaximum = null;
        Boolean uniqueItems = null;
        JsonNode detailNode = node.get("example");
        String example = detailNode != null ? detailNode.asText() : null;
        detailNode = node.get("enum");
        if (detailNode != null) {
            ArrayNode an = (ArrayNode)detailNode;
            output = new ArrayList();
            for (int i = 0; i < an.size(); ++i) {
                JsonNode child = an.get(i);
                if (!(child instanceof TextNode)) continue;
                output.add(((TextNode)child).asText());
            }
            _enum = output;
        }
        if ((detailNode = node.get("type")) != null) {
            type = ((TextNode)detailNode).asText();
        }
        if ((detailNode = node.get("format")) != null) {
            format = ((TextNode)detailNode).asText();
        }
        if ((detailNode = node.get("title")) != null) {
            title = ((TextNode)detailNode).asText();
        }
        if ((detailNode = node.get("description")) != null) {
            description = ((TextNode)detailNode).asText();
        }
        if ((detailNode = node.get("default")) != null) {
            _default = detailNode.toString();
        }
        if ((detailNode = node.get("pattern")) != null) {
            pattern = ((TextNode)detailNode).asText();
        }
        if ((detailNode = node.get("discriminator")) != null) {
            discriminator = ((TextNode)detailNode).asText();
        }
        if ((detailNode = node.get("minItems")) != null) {
            minItems = new Integer(((NumericNode)detailNode).intValue());
        }
        if ((detailNode = node.get("maxItems")) != null) {
            maxItems = new Integer(((NumericNode)detailNode).intValue());
        }
        if ((detailNode = node.get("minProperties")) != null) {
            minProperties = new Integer(((NumericNode)detailNode).intValue());
        }
        if ((detailNode = node.get("maxProperties")) != null) {
            maxProperties = new Integer(((NumericNode)detailNode).intValue());
        }
        if ((detailNode = node.get("maxLength")) != null) {
            maxLength = new Integer(((NumericNode)detailNode).intValue());
        }
        if ((detailNode = node.get("minLength")) != null) {
            minLength = new Integer(((NumericNode)detailNode).intValue());
        }
        if ((detailNode = node.get("minimum")) != null) {
            minimum = new Double(((NumericNode)detailNode).doubleValue());
        }
        if ((detailNode = node.get("maximum")) != null) {
            maximum = new Double(((NumericNode)detailNode).doubleValue());
        }
        if ((detailNode = node.get("exclusiveMinimum")) != null) {
            exclusiveMinimum = new Double(((NumericNode)detailNode).doubleValue());
        }
        if ((detailNode = node.get("exclusiveMaximum")) != null) {
            exclusiveMaximum = new Double(((NumericNode)detailNode).doubleValue());
        }
        if ((detailNode = node.get("uniqueItems")) != null) {
            uniqueItems = ((BooleanNode)detailNode).booleanValue();
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("example", example);
        args.put("enum", _enum);
        args.put("type", type);
        args.put("format", format);
        args.put("title", title);
        args.put("description", description);
        args.put("default", _default);
        args.put("pattern", pattern);
        args.put("discriminator", discriminator);
        args.put("minItems", minItems);
        args.put("maxItems", maxItems);
        args.put("minProperties", minProperties);
        args.put("maxProperties", maxProperties);
        args.put("minLength", minLength);
        args.put("maxLength", maxLength);
        args.put("minimum", minimum);
        args.put("maximum", maximum);
        args.put("exclusiveMinimum", exclusiveMinimum);
        args.put("exclusiveMaximum", exclusiveMinimum);
        args.put("uniqueItems", uniqueItems);
        detailNode = node.get("$ref");
        if (detailNode != null) {
            String ref = ((TextNode)detailNode).asText();
            return new RefProperty(ref).description(description);
        }
        if ("object".equals(type) && (detailNode = node.get("additionalProperties")) != null && (items = this.propertyFromNode(detailNode)) != null) {
            return new MapProperty(items).description(description);
        }
        if ("array".equals(type) && (detailNode = node.get("items")) != null) {
            Property subProperty = this.propertyFromNode(detailNode);
            return new ArrayProperty().items(subProperty).description(description);
        }
        output = PropertyBuilder.build((String)type, (String)format, args);
        if (output == null) {
            this.LOGGER.warn("no property from " + type + ", " + format + ", " + args);
            return null;
        }
        output.setDescription(description);
        return output;
    }
}

