/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.wordnik.swagger.models.parameters.BodyParameter;
import com.wordnik.swagger.models.parameters.CookieParameter;
import com.wordnik.swagger.models.parameters.FormParameter;
import com.wordnik.swagger.models.parameters.HeaderParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.parameters.PathParameter;
import com.wordnik.swagger.models.parameters.QueryParameter;
import com.wordnik.swagger.models.parameters.RefParameter;
import com.wordnik.swagger.util.Json;
import java.io.IOException;

public class ParameterDeserializer
extends JsonDeserializer<Parameter> {
    public Parameter deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Parameter result = null;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode sub = node.get("$ref");
        JsonNode inNode = node.get("in");
        if (sub != null) {
            result = (Parameter)Json.mapper().convertValue((Object)sub, RefParameter.class);
        } else if (inNode != null) {
            String in = inNode.asText();
            if ("query".equals(in)) {
                result = (Parameter)Json.mapper().convertValue((Object)node, QueryParameter.class);
            } else if ("header".equals(in)) {
                result = (Parameter)Json.mapper().convertValue((Object)node, HeaderParameter.class);
            } else if ("path".equals(in)) {
                result = (Parameter)Json.mapper().convertValue((Object)node, PathParameter.class);
            } else if ("formData".equals(in)) {
                result = (Parameter)Json.mapper().convertValue((Object)node, FormParameter.class);
            } else if ("body".equals(in)) {
                result = (Parameter)Json.mapper().convertValue((Object)node, BodyParameter.class);
            } else if ("cookie".equals(in)) {
                result = (Parameter)Json.mapper().convertValue((Object)node, CookieParameter.class);
            }
        }
        return result;
    }
}

