/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.auth.SecuritySchemeDefinition;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.util.ModelDeserializer;
import com.wordnik.swagger.util.ParameterDeserializer;
import com.wordnik.swagger.util.PropertyDeserializer;
import com.wordnik.swagger.util.SecurityDefinitionDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Json {
    static Logger LOGGER = LoggerFactory.getLogger(Json.class);
    static ObjectMapper mapper;

    public static ObjectMapper mapper() {
        if (mapper == null) {
            mapper = Json.create();
        }
        return mapper;
    }

    public static ObjectMapper create() {
        mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Property.class, (JsonDeserializer)new PropertyDeserializer());
        module.addDeserializer(Model.class, (JsonDeserializer)new ModelDeserializer());
        module.addDeserializer(Parameter.class, (JsonDeserializer)new ParameterDeserializer());
        module.addDeserializer(SecuritySchemeDefinition.class, (JsonDeserializer)new SecurityDefinitionDeserializer());
        mapper.registerModule((Module)module);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static ObjectWriter pretty() {
        return Json.mapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
    }

    public static String pretty(Object o) {
        try {
            return Json.pretty().writeValueAsString(o);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void prettyPrint(Object o) {
        try {
            System.out.println(Json.pretty().writeValueAsString(o).replace("\r", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

