/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jackson;

import com.fasterxml.jackson.databind.JavaType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class TypeNameResolver {
    public static final TypeNameResolver std = new TypeNameResolver();
    public static final String TYPE_DATE_TIME = "dateTime";
    public static final String TYPE_DATE = "date";
    protected static final Map<Class<?>, String> JDK_TYPES = TypeNameResolver.jdkTypes();
    protected static final Map<String, String> EXTERNAL_TYPES = TypeNameResolver.externalTypes();

    protected TypeNameResolver() {
    }

    public String nameForType(JavaType type) {
        Class raw = type.getRawClass();
        String name = this.findStdName(raw);
        return name == null ? (name = raw.getSimpleName()) : name;
    }

    protected String findStdName(Class<?> raw) {
        String name = JDK_TYPES.get(raw);
        if (name == null) {
            name = EXTERNAL_TYPES.get(raw.getName());
            if (name == null) {
                if (Date.class.isAssignableFrom(raw)) {
                    return TYPE_DATE_TIME;
                }
                if (Calendar.class.isAssignableFrom(raw)) {
                    return TYPE_DATE_TIME;
                }
            }
            return name;
        }
        return name;
    }

    private static Map<Class<?>, String> jdkTypes() {
        HashMap map = new HashMap();
        TypeNameResolver._add(map, "boolean", Boolean.class, Boolean.TYPE);
        TypeNameResolver._add(map, "byte", Byte.class, Byte.TYPE);
        TypeNameResolver._add(map, "integer", Integer.class, Integer.TYPE, Short.class, Short.TYPE);
        TypeNameResolver._add(map, "long", Long.class, Long.TYPE, BigInteger.class);
        TypeNameResolver._add(map, "float", Float.class, Float.TYPE);
        TypeNameResolver._add(map, "double", Double.class, Double.TYPE, BigDecimal.class);
        TypeNameResolver._add(map, "string", String.class, Character.class, Character.TYPE);
        TypeNameResolver._add(map, "string", UUID.class, URL.class, URI.class);
        return map;
    }

    private static Map<String, String> externalTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("org.joda.time.DateTime", TYPE_DATE_TIME);
        map.put("org.joda.time.LocalDate", TYPE_DATE);
        map.put("org.joda.time.ReadableDateTime", TYPE_DATE_TIME);
        map.put("javax.xml.datatype.XMLGregorianCalendar", TYPE_DATE_TIME);
        return map;
    }

    private static Map<Class<?>, String> _add(Map<Class<?>, String> map, String name, Class<?> ... types) {
        for (Class<?> type : types) {
            map.put(type, name);
        }
        return map;
    }
}

