/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.converter.ModelConverter;
import com.wordnik.swagger.converter.ModelConverterContext;
import com.wordnik.swagger.jackson.AbstractModelConverter;
import com.wordnik.swagger.models.ComposedModel;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.ModelImpl;
import com.wordnik.swagger.models.RefModel;
import com.wordnik.swagger.models.Xml;
import com.wordnik.swagger.models.properties.AbstractNumericProperty;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.MapProperty;
import com.wordnik.swagger.models.properties.ObjectProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.RefProperty;
import com.wordnik.swagger.models.properties.StringProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelResolver
extends AbstractModelConverter
implements ModelConverter {
    Logger LOGGER = LoggerFactory.getLogger(ModelResolver.class);

    public ModelResolver(ObjectMapper mapper) {
        super(mapper);
    }

    public ObjectMapper objectMapper() {
        return this._mapper;
    }

    protected boolean shouldIgnoreClass(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls.getName().equals("javax.ws.rs.Response")) {
                return true;
            }
        } else {
            this.LOGGER.debug("can't check class " + type);
        }
        return false;
    }

    @Override
    public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolveProperty(this._mapper.constructType(type), context, annotations, next);
    }

    public Property resolveProperty(JavaType propType, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        Property property = null;
        String typeName = this._typeName(propType);
        this.LOGGER.debug("resolveProperty " + propType);
        property = this.getPrimitiveProperty(typeName);
        if (propType.isContainerType()) {
            JavaType keyType = propType.getKeyType();
            JavaType valueType = propType.getContentType();
            if (keyType != null && valueType != null) {
                MapProperty mapProperty = new MapProperty();
                Property innerType = this.getPrimitiveProperty(this._typeName(valueType));
                if (innerType == null) {
                    String propertyTypeName = this._typeName(valueType);
                    Model innerModel = context.resolve((Type)valueType);
                    if (innerModel != null) {
                        if (!"Object".equals(propertyTypeName)) {
                            innerType = new RefProperty(propertyTypeName);
                            mapProperty.additionalProperties(innerType);
                            property = mapProperty;
                        } else {
                            innerType = new ObjectProperty();
                            mapProperty.additionalProperties(innerType);
                            property = mapProperty;
                        }
                    }
                } else {
                    mapProperty.additionalProperties(innerType);
                    property = mapProperty;
                }
            } else if (valueType != null) {
                ArrayProperty arrayProperty = new ArrayProperty();
                Property innerType = this.getPrimitiveProperty(this._typeName(valueType));
                if (innerType == null) {
                    this.LOGGER.debug("no primitive property type from " + valueType);
                    String propertyTypeName = this._typeName(valueType);
                    this.LOGGER.debug("using name " + propertyTypeName);
                    if (!"Object".equals(propertyTypeName)) {
                        Model innerModel = context.resolve((Type)valueType);
                        this.LOGGER.debug("got inner model " + innerModel);
                        if (innerModel != null) {
                            Class cls;
                            ModelImpl impl;
                            this.LOGGER.debug("found inner model " + innerModel);
                            if (innerModel instanceof ModelImpl && (impl = (ModelImpl)innerModel).getName() != null) {
                                propertyTypeName = impl.getName();
                            }
                            if (this._isSetType(cls = propType.getRawClass())) {
                                arrayProperty.setUniqueItems(Boolean.valueOf(true));
                            }
                            innerType = new RefProperty(propertyTypeName);
                            arrayProperty.setItems(innerType);
                            property = arrayProperty;
                        }
                    } else {
                        this.LOGGER.debug("falling back to object type");
                        innerType = new ObjectProperty();
                        arrayProperty.setItems(innerType);
                        property = arrayProperty;
                    }
                } else {
                    Class cls;
                    if (keyType == null && this._isSetType(cls = propType.getRawClass())) {
                        arrayProperty.setUniqueItems(Boolean.valueOf(true));
                    }
                    arrayProperty.setItems(innerType);
                    property = arrayProperty;
                }
            }
        }
        if (property == null) {
            if (propType.isEnumType()) {
                property = new StringProperty();
                this._addEnumProps(propType.getRawClass(), property);
            } else if (this._isOptionalType(propType)) {
                property = context.resolveProperty((Type)propType.containedType(0), null);
            } else {
                String propertyTypeName = this._typeName(propType);
                Model innerModel = context.resolve((Type)propType);
                if (innerModel != null) {
                    property = new RefProperty(propertyTypeName);
                }
            }
        }
        return property;
    }

    private boolean _isOptionalType(JavaType propType) {
        return "com.google.common.base.Optional".equals(propType.getRawClass().getCanonicalName());
    }

    @Override
    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolve(this._mapper.constructType(type), context, next);
    }

    protected void _addEnumProps(Class<?> propClass, Property property) {
        boolean useIndex = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        boolean useToString = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        Class<?> enumClass = propClass;
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            String n = useIndex ? String.valueOf(en.ordinal()) : (useToString ? en.toString() : this._intr.findEnumValue(en));
            if (!(property instanceof StringProperty)) continue;
            StringProperty sp = (StringProperty)property;
            sp._enum(n);
        }
    }

    public Model resolve(JavaType type, ModelConverterContext context, Iterator<ModelConverter> next) {
        JsonTypeInfo typeInfo;
        String disc;
        ApiModel apiModel;
        String name;
        BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(type);
        if (type.isEnumType()) {
            // empty if block
        }
        if ("Object".equals(name = this._typeName(type, beanDesc))) {
            return new ModelImpl();
        }
        if (type.isMapLikeType()) {
            return null;
        }
        ModelImpl model = new ModelImpl().name(name).description(this._description((Annotated)beanDesc.getClassInfo()));
        XmlRootElement rootAnnotation = (XmlRootElement)beanDesc.getClassAnnotations().get(XmlRootElement.class);
        if (rootAnnotation != null && !"".equals(rootAnnotation.name()) && !"##default".equals(rootAnnotation.name())) {
            this.LOGGER.debug(rootAnnotation.toString());
            Xml xml = new Xml().name(rootAnnotation.name());
            if (rootAnnotation.namespace() != null && !"".equals(rootAnnotation.namespace()) && !"##default".equals(rootAnnotation.namespace())) {
                xml.namespace(rootAnnotation.namespace());
            }
            model.xml(xml);
        }
        if ((apiModel = (ApiModel)beanDesc.getClassAnnotations().get(ApiModel.class)) != null) {
            Class parent;
            if (apiModel.value() != null && !"".equals(apiModel.value())) {
                name = apiModel.value();
                model.setName(name);
            }
            if ((parent = apiModel.parent()) != Void.class) {
                // empty if block
            }
        }
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        JsonIgnoreProperties ignoreProperties = (JsonIgnoreProperties)beanDesc.getClassAnnotations().get(JsonIgnoreProperties.class);
        if (ignoreProperties != null) {
            propertiesToIgnore.addAll(Arrays.asList(ignoreProperties.value()));
        }
        String string = disc = apiModel == null ? "" : apiModel.discriminator();
        if (disc.isEmpty() && (typeInfo = (JsonTypeInfo)beanDesc.getClassAnnotations().get(JsonTypeInfo.class)) != null) {
            disc = typeInfo.property();
        }
        if (!disc.isEmpty()) {
            model.setDiscriminator(disc);
        }
        ArrayList<Property> props = new ArrayList<Property>();
        for (BeanPropertyDefinition propDef : beanDesc.findProperties()) {
            Integer index;
            String description;
            JsonProperty pd;
            String altName;
            Member member;
            Property property = null;
            String propName = propDef.getName();
            Annotation[] annotations = null;
            if (propDef.getPrimaryMember() != null && (member = propDef.getPrimaryMember().getMember()) != null && (altName = member.getName()) != null) {
                if (altName.startsWith("get")) {
                    if (!Character.isUpperCase(altName.charAt(3))) {
                        propName = altName;
                    }
                } else if (altName.startsWith("is") && !Character.isUpperCase(altName.charAt(2))) {
                    propName = altName;
                }
            }
            PropertyMetadata md = propDef.getMetadata();
            boolean hasSetter = false;
            boolean hasGetter = false;
            hasSetter = propDef.getSetter() != null;
            if (propDef.getGetter() != null && (pd = (JsonProperty)propDef.getGetter().getAnnotation(JsonProperty.class)) != null) {
                hasGetter = true;
            }
            Boolean isReadOnly = null;
            isReadOnly = !hasSetter & hasGetter ? Boolean.TRUE : Boolean.FALSE;
            AnnotatedMember member2 = propDef.getPrimaryMember();
            if (member2 == null || propertiesToIgnore.contains(propName)) continue;
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            for (Annotation a : member2.annotations()) {
                annotationList.add(a);
            }
            annotations = annotationList.toArray(new Annotation[annotationList.size()]);
            ApiModelProperty mp = (ApiModelProperty)member2.getAnnotation(ApiModelProperty.class);
            JavaType propType = member2.getType(beanDesc.bindingsForBeanType());
            if (mp != null && !mp.name().isEmpty()) {
                propName = mp.name();
            }
            if (mp != null && !mp.dataType().isEmpty()) {
                String or = mp.dataType();
                JavaType innerJavaType = null;
                this.LOGGER.debug("overriding datatype from " + propType + " to " + or);
                if (or.toLowerCase().startsWith("list[")) {
                    String innerType = or.substring(5, or.length() - 1);
                    ArrayProperty p = new ArrayProperty();
                    Property primitiveProperty = this.getPrimitiveProperty(innerType);
                    if (primitiveProperty != null) {
                        p.setItems(primitiveProperty);
                    } else {
                        innerJavaType = this.getInnerType(innerType);
                        p.setItems(context.resolveProperty((Type)innerJavaType, annotations));
                    }
                    property = p;
                } else if (or.toLowerCase().startsWith("map[")) {
                    int pos = or.indexOf(",");
                    if (pos > 0) {
                        String innerType = or.substring(pos + 1, or.length() - 1);
                        MapProperty p = new MapProperty();
                        Property primitiveProperty = this.getPrimitiveProperty(innerType);
                        if (primitiveProperty != null) {
                            p.setAdditionalProperties(primitiveProperty);
                        } else {
                            innerJavaType = this.getInnerType(innerType);
                            p.setAdditionalProperties(context.resolveProperty((Type)innerJavaType, annotations));
                        }
                        property = p;
                    }
                } else {
                    Property primitiveProperty = this.getPrimitiveProperty(or);
                    if (primitiveProperty != null) {
                        property = primitiveProperty;
                    } else {
                        innerJavaType = this.getInnerType(or);
                        property = context.resolveProperty((Type)innerJavaType, annotations);
                    }
                }
                if (innerJavaType != null) {
                    context.resolve((Type)innerJavaType);
                }
            }
            if (property == null) {
                property = context.resolveProperty((Type)propType, annotations);
            }
            if (property == null) continue;
            property.setName(propName);
            Boolean required = md.getRequired();
            if (required != null) {
                property.setRequired(required.booleanValue());
            }
            if ((description = this._intr.findPropertyDescription((Annotated)member2)) != null && !"".equals(description)) {
                property.setDescription(description);
            }
            if ((index = this._intr.findPropertyIndex((Annotated)member2)) != null) {
                property.setPosition(index);
            }
            property.setDefault(this._findDefaultValue((Annotated)member2));
            property.setExample(this._findExampleValue((Annotated)member2));
            property.setReadOnly(this._findReadOnly((Annotated)member2));
            if (property.getReadOnly() == null && isReadOnly.booleanValue()) {
                property.setReadOnly(isReadOnly);
            }
            if (property instanceof StringProperty && mp != null) {
                String allowableValues = mp.allowableValues();
                this.LOGGER.debug("allowableValues " + allowableValues);
                if (!"".equals(allowableValues)) {
                    String[] parts = allowableValues.split(",");
                    this.LOGGER.debug("found " + parts.length + " parts");
                    for (String part : parts) {
                        if (!(property instanceof StringProperty)) continue;
                        StringProperty sp = (StringProperty)property;
                        sp._enum(part.trim());
                        this.LOGGER.debug("added enum value " + part);
                    }
                }
            }
            if (property != null) {
                XmlAttribute attr;
                XmlElement element;
                XmlElementWrapper wrapper = (XmlElementWrapper)member2.getAnnotation(XmlElementWrapper.class);
                if (wrapper != null) {
                    Xml xml = new Xml();
                    xml.setWrapped(Boolean.valueOf(true));
                    if (wrapper.name() != null) {
                        if ("##default".equals(wrapper.name())) {
                            xml.setName(propName);
                        } else if (!"".equals(wrapper.name())) {
                            xml.setName(wrapper.name());
                        }
                    }
                    if (wrapper.namespace() != null && !"".equals(wrapper.namespace()) && !"##default".equals(wrapper.namespace())) {
                        xml.setNamespace(wrapper.namespace());
                    }
                    property.setXml(xml);
                }
                if (!((element = (XmlElement)member2.getAnnotation(XmlElement.class)) == null || element.name().isEmpty() || element.name().equals(propName) || "##default".equals(element.name()))) {
                    Xml xml = property.getXml();
                    if (xml == null) {
                        xml = new Xml();
                        property.setXml(xml);
                    }
                    xml.setName(element.name());
                }
                if (!((attr = (XmlAttribute)member2.getAnnotation(XmlAttribute.class)) == null || "".equals(attr.name()) || attr.name().equals(propName) || "##default".equals(attr.name()))) {
                    Xml xml = property.getXml();
                    if (xml == null) {
                        xml = new Xml();
                        property.setXml(xml);
                    }
                    xml.setName(attr.name());
                }
            }
            this.applyBeanValidatorAnnotations(property, annotations);
            props.add(property);
        }
        List nts = this._intr.findSubtypes((Annotated)beanDesc.getClassInfo());
        if (nts != null) {
            ArrayList subtypeNames = new ArrayList();
            for (NamedType subtype : nts) {
                Model subtypeModel = context.resolve(subtype.getType());
                if (!(subtypeModel instanceof ModelImpl) || subtypeModel == null) continue;
                ModelImpl impl = (ModelImpl)subtypeModel;
                if (model.getProperties() != null) {
                    for (String propertyName : model.getProperties().keySet()) {
                        if (!impl.getProperties().containsKey(propertyName)) continue;
                        impl.getProperties().remove(propertyName);
                    }
                }
                impl.setDiscriminator(null);
                ComposedModel child = new ComposedModel().parent((Model)new RefModel(name)).child((Model)impl);
                context.defineModel(impl.getName(), (Model)child);
            }
        }
        Collections.sort(props, ModelResolver.getPropertyComparator());
        LinkedHashMap<String, Property> modelProps = new LinkedHashMap<String, Property>();
        for (Property prop : props) {
            modelProps.put(prop.getName(), prop);
        }
        if (modelProps.size() == 0) {
            model.setType("object");
        }
        model.setProperties(modelProps);
        return model;
    }

    protected void applyBeanValidatorAnnotations(Property property, Annotation[] annotations) {
        Max max;
        Min min;
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            for (Annotation anno : annotations) {
                annos.put(anno.annotationType().getName(), anno);
            }
        }
        if (annos.containsKey("javax.validation.constraints.NotNull")) {
            property.setRequired(true);
        }
        if (annos.containsKey("javax.validation.constraints.Min") && property instanceof AbstractNumericProperty) {
            min = (Min)annos.get("javax.validation.constraints.Min");
            AbstractNumericProperty ap = (AbstractNumericProperty)property;
            ap.setMinimum(new Double(min.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Max") && property instanceof AbstractNumericProperty) {
            max = (Max)annos.get("javax.validation.constraints.Max");
            AbstractNumericProperty ap = (AbstractNumericProperty)property;
            ap.setMaximum(new Double(max.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Size")) {
            Size size = (Size)annos.get("javax.validation.constraints.Size");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                ap.setMinimum(new Double(size.min()));
                ap.setMaximum(new Double(size.max()));
            }
            if (property instanceof StringProperty) {
                StringProperty sp = (StringProperty)property;
                sp.minLength(new Integer(size.min()));
                sp.maxLength(new Integer(size.max()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMin")) {
            min = (DecimalMin)annos.get("javax.validation.constraints.DecimalMin");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                if (min.inclusive()) {
                    ap.setMinimum(new Double(min.value()));
                } else {
                    ap.setExclusiveMinimum(new Double(min.value()));
                }
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMax")) {
            max = (DecimalMax)annos.get("javax.validation.constraints.DecimalMax");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                if (max.inclusive()) {
                    ap.setMaximum(new Double(max.value()));
                } else {
                    ap.setExclusiveMaximum(new Double(max.value()));
                }
            }
        }
    }

    protected JavaType getInnerType(String innerType) {
        try {
            Class<?> innerClass = Class.forName(innerType);
            if (innerClass != null) {
                TypeFactory tf = this._mapper.getTypeFactory();
                return tf.constructType(innerClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

