/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.converter.ModelConverter;
import com.wordnik.swagger.converter.ModelConverterContext;
import com.wordnik.swagger.jackson.SwaggerAnnotationIntrospector;
import com.wordnik.swagger.jackson.TypeNameResolver;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.properties.BooleanProperty;
import com.wordnik.swagger.models.properties.DateProperty;
import com.wordnik.swagger.models.properties.DateTimeProperty;
import com.wordnik.swagger.models.properties.DoubleProperty;
import com.wordnik.swagger.models.properties.FloatProperty;
import com.wordnik.swagger.models.properties.IntegerProperty;
import com.wordnik.swagger.models.properties.LongProperty;
import com.wordnik.swagger.models.properties.ObjectProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.StringProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlElement;

public abstract class AbstractModelConverter
implements ModelConverter {
    protected final ObjectMapper _mapper;
    protected final AnnotationIntrospector _intr;
    protected final TypeNameResolver _typeNameResolver = TypeNameResolver.std;
    protected Map<JavaType, String> _resolvedTypeNames = new ConcurrentHashMap<JavaType, String>();

    protected AbstractModelConverter(ObjectMapper mapper) {
        mapper.registerModule((Module)new SimpleModule("swagger", Version.unknownVersion()){

            public void setupModule(Module.SetupContext context) {
                context.insertAnnotationIntrospector((AnnotationIntrospector)new SwaggerAnnotationIntrospector());
            }
        });
        this._mapper = mapper;
        this._intr = mapper.getSerializationConfig().getAnnotationIntrospector();
    }

    protected static Comparator<Property> getPropertyComparator() {
        return new Comparator<Property>(){

            @Override
            public int compare(Property one, Property two) {
                if (one.getPosition() == null && two.getPosition() == null) {
                    return 0;
                }
                if (one.getPosition() == null) {
                    return -1;
                }
                if (two.getPosition() == null) {
                    return 1;
                }
                return one.getPosition().compareTo(two.getPosition());
            }
        };
    }

    @Override
    public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolveProperty(type, context, annotations, chain);
        }
        return null;
    }

    protected Property getPrimitiveProperty(String typeName) {
        BooleanProperty property = null;
        if ("boolean".equalsIgnoreCase(typeName)) {
            property = new BooleanProperty();
        } else if ("string".equalsIgnoreCase(typeName)) {
            property = new StringProperty();
        } else if ("integer".equalsIgnoreCase(typeName) || "int".toLowerCase().equalsIgnoreCase(typeName)) {
            property = new IntegerProperty();
        } else if ("long".equalsIgnoreCase(typeName)) {
            property = new LongProperty();
        } else if ("float".equalsIgnoreCase(typeName)) {
            property = new FloatProperty();
        } else if ("double".equalsIgnoreCase(typeName)) {
            property = new DoubleProperty();
        } else if ("dateTime".equalsIgnoreCase(typeName)) {
            property = new DateTimeProperty();
        } else if ("date".equalsIgnoreCase(typeName)) {
            property = new DateProperty();
        } else if ("byte".equalsIgnoreCase(typeName)) {
            property = new StringProperty();
            ((StringProperty)property).setFormat("byte");
        } else if ("object".equalsIgnoreCase(typeName)) {
            property = new ObjectProperty();
        }
        return property;
    }

    protected String _description(Annotated ann) {
        return this._intr.findPropertyDescription(ann);
    }

    protected String _typeName(JavaType type) {
        return this._typeName(type, null);
    }

    protected String _typeName(JavaType type, BeanDescription beanDesc) {
        String name = this._resolvedTypeNames.get(type);
        if (name != null) {
            return name;
        }
        name = this._findTypeName(type, beanDesc);
        this._resolvedTypeNames.put(type, name);
        return name;
    }

    protected String _findTypeName(JavaType type, BeanDescription beanDesc) {
        PropertyName rootName;
        if (type.isArrayType()) {
            return "Array";
        }
        if (type.isMapLikeType()) {
            return "Map";
        }
        if (type.isContainerType()) {
            if (Set.class.isAssignableFrom(type.getRawClass())) {
                return "Set";
            }
            return "List";
        }
        if (beanDesc == null) {
            beanDesc = this._mapper.getSerializationConfig().introspectClassAnnotations(type);
        }
        if ((rootName = this._intr.findRootName(beanDesc.getClassInfo())) != null && rootName.hasSimpleName()) {
            return rootName.getSimpleName();
        }
        return this._typeNameResolver.nameForType(type);
    }

    protected String _typeQName(JavaType type) {
        return type.getRawClass().getName();
    }

    protected String _subTypeName(NamedType type) {
        return type.getType().getName();
    }

    protected String _findDefaultValue(Annotated a) {
        XmlElement elem = (XmlElement)a.getAnnotation(XmlElement.class);
        if (elem != null && !elem.defaultValue().isEmpty() && !"\u0000".equals(elem.defaultValue())) {
            return elem.defaultValue();
        }
        return null;
    }

    protected String _findExampleValue(Annotated a) {
        ApiModelProperty prop = (ApiModelProperty)a.getAnnotation(ApiModelProperty.class);
        if (prop != null && !prop.example().isEmpty()) {
            return prop.example();
        }
        return null;
    }

    protected Boolean _findReadOnly(Annotated a) {
        ApiModelProperty prop = (ApiModelProperty)a.getAnnotation(ApiModelProperty.class);
        if (prop != null) {
            return prop.readOnly();
        }
        return null;
    }

    protected boolean _isSetType(Class<?> cls) {
        if (cls != null) {
            if (Set.class.equals(cls)) {
                return true;
            }
            for (Class<?> a : cls.getInterfaces()) {
                if (!Set.class.equals(a) && !"interface scala.collection.Set".equals(a.toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }
}

