/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.converter;

import com.wordnik.swagger.converter.ModelConverter;
import com.wordnik.swagger.converter.ModelConverterContextImpl;
import com.wordnik.swagger.jackson.ModelResolver;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.util.Json;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelConverters {
    static Logger LOGGER = LoggerFactory.getLogger(ModelConverters.class);
    private static final ModelConverters SINGLETON = new ModelConverters();
    private final List<ModelConverter> converters;
    private final Set<String> skippedPackages = new HashSet<String>();
    private final Set<String> skippedClasses = new HashSet<String>();

    public static ModelConverters getInstance() {
        return SINGLETON;
    }

    public ModelConverters() {
        this.converters = new CopyOnWriteArrayList<ModelConverter>();
        this.converters.add(new ModelResolver(Json.mapper()));
    }

    public void addConverter(ModelConverter converter) {
        this.converters.add(0, converter);
    }

    public void removeConverter(ModelConverter converter) {
        this.converters.remove(converter);
    }

    public void addPackageToSkip(String pkg) {
        this.skippedPackages.add(pkg);
    }

    public void addClassToSkip(String cls) {
        LOGGER.warn("skipping class " + cls);
        this.skippedClasses.add(cls);
    }

    public Property readAsProperty(Type type) {
        ModelConverterContextImpl context = new ModelConverterContextImpl(this.converters);
        return context.resolveProperty(type, null);
    }

    public Map<String, Model> read(Type type) {
        HashMap<String, Model> modelMap = new HashMap<String, Model>();
        if (this.shouldProcess(type)) {
            ModelConverterContextImpl context = new ModelConverterContextImpl(this.converters);
            Model resolve = context.resolve(type);
            for (Map.Entry<String, Model> entry : context.getDefinedModels().entrySet()) {
                if (!entry.getValue().equals(resolve)) continue;
                modelMap.put(entry.getKey(), entry.getValue());
            }
        }
        return modelMap;
    }

    public Map<String, Model> readAll(Type type) {
        if (this.shouldProcess(type)) {
            ModelConverterContextImpl context = new ModelConverterContextImpl(this.converters);
            LOGGER.debug("ModelConverters readAll from " + type);
            context.resolve(type);
            return context.getDefinedModels();
        }
        return new HashMap<String, Model>();
    }

    private boolean shouldProcess(Type type) {
        boolean process = true;
        if (type instanceof Class) {
            Class cls = (Class)type;
            String className = cls.getName();
            for (String packageName : this.skippedPackages) {
                if (!className.startsWith(packageName)) continue;
                process = false;
            }
            for (String classToSkip : this.skippedClasses) {
                if (!className.equals(classToSkip)) continue;
                process = false;
            }
        }
        return process;
    }

    static {
        ModelConverters.SINGLETON.skippedPackages.add("java.lang");
        ServiceLoader<ModelConverter> loader = ServiceLoader.load(ModelConverter.class);
        for (ModelConverter ext : loader) {
            if (ext == null) {
                LOGGER.error("failed to load extension " + ext);
                continue;
            }
            SINGLETON.addConverter(ext);
            LOGGER.debug("adding ModelConverter: " + ext);
        }
    }
}

