/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.rt;

import com.webcohesion.enunciate.metadata.qname.XmlQNameEnum;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumValue;
import com.webcohesion.enunciate.metadata.qname.XmlUnknownQNameEnumValue;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;

public class QNameEnumUtil {
    private static final AtomicReference<String> DEFAULT_BASE_URI = new AtomicReference();
    private static final AtomicBoolean WRITE_RELATIVE_URIS = new AtomicBoolean(false);
    private static final QName UNKNOWN_QNAME_ENUM = new QName("enunciate:qname-enum", "UNKNOWN");
    private static final QName EXCLUDED_QNAME_ENUM = new QName("enunciate:qname-enum", "EXCLUDED");
    private static final Map<Class<? extends Enum>, Map<? extends Enum, QName>> QNAME_CACHE = new ConcurrentHashMap<Class<? extends Enum>, Map<? extends Enum, QName>>();

    private QNameEnumUtil() {
    }

    public static void setDefaultBaseUri(String uri) {
        DEFAULT_BASE_URI.set(uri);
    }

    public static String getDefaultBaseUri() {
        return DEFAULT_BASE_URI.get();
    }

    public static boolean isWriteRelativeUris() {
        return WRITE_RELATIVE_URIS.get();
    }

    public static void setWriteRelativeUris(boolean writeRelativeUris) {
        WRITE_RELATIVE_URIS.set(writeRelativeUris);
    }

    public static <Q extends Enum<Q>> Q fromQName(QName qname, Class<Q> clazz) {
        XmlQNameEnum enumInfo;
        if (qname == null) {
            return null;
        }
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException(String.format("Class %s isn't a QName enum.", clazz.getName()));
        }
        Map<? extends Enum, QName> qNameMap = QNAME_CACHE.get(clazz);
        if (qNameMap == null) {
            qNameMap = QNameEnumUtil.createQNameMap(clazz);
            QNAME_CACHE.put(clazz, qNameMap);
        }
        if ((enumInfo = clazz.getAnnotation(XmlQNameEnum.class)).base() != XmlQNameEnum.BaseType.QNAME) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is supposed to be converted from a URI (not QName).");
        }
        Enum defaultValue = null;
        for (Map.Entry<? extends Enum, QName> qNameEntry : qNameMap.entrySet()) {
            if (qNameEntry.getValue().equals(qname)) {
                return (Q)qNameEntry.getKey();
            }
            if (defaultValue != null || !UNKNOWN_QNAME_ENUM.equals(qNameEntry.getValue())) continue;
            defaultValue = qNameEntry.getKey();
        }
        return (Q)defaultValue;
    }

    public static QName toQName(Enum e) {
        XmlQNameEnum enumInfo;
        if (e == null) {
            return null;
        }
        if (!e.getDeclaringClass().isEnum()) {
            throw new IllegalArgumentException(String.format("Class %s isn't a QName enum.", e.getDeclaringClass().getName()));
        }
        Class clazz = e.getDeclaringClass();
        Map<? extends Enum, QName> qNameMap = QNAME_CACHE.get(clazz);
        if (qNameMap == null) {
            qNameMap = QNameEnumUtil.createQNameMap(clazz);
            QNAME_CACHE.put(clazz, qNameMap);
        }
        if ((enumInfo = clazz.getAnnotation(XmlQNameEnum.class)).base() != XmlQNameEnum.BaseType.QNAME) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is supposed to be converted from a URI (not QName).");
        }
        QName result = qNameMap.get(e);
        if (result == null) {
            throw new IllegalStateException("Unable to find " + e.getDeclaringClass().getName() + "." + e + " as a QName enum value.");
        }
        if (UNKNOWN_QNAME_ENUM.equals(result)) {
            throw new IllegalArgumentException(e.getDeclaringClass().getName() + "." + e + " is not a QName enum value.");
        }
        if (EXCLUDED_QNAME_ENUM.equals(result)) {
            throw new IllegalArgumentException(e.getDeclaringClass().getName() + "." + e + " is excluded a QName enum value.");
        }
        return result;
    }

    public static <Q extends Enum<Q>> Q fromURI(String uriValue, Class<Q> clazz) {
        return QNameEnumUtil.fromURI(uriValue, clazz, QNameEnumUtil.getDefaultBaseUri());
    }

    public static <Q extends Enum<Q>> Q fromURI(String uriValue, Class<Q> clazz, String defaultBaseUri) {
        XmlQNameEnum enumInfo;
        if (uriValue == null) {
            return null;
        }
        if (defaultBaseUri != null) {
            uriValue = URI.create(defaultBaseUri).resolve(uriValue).toString();
        }
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException(String.format("Class %s isn't a QName enum.", clazz.getName()));
        }
        Map<? extends Enum, QName> qNameMap = QNAME_CACHE.get(clazz);
        if (qNameMap == null) {
            qNameMap = QNameEnumUtil.createQNameMap(clazz);
            QNAME_CACHE.put(clazz, qNameMap);
        }
        if ((enumInfo = clazz.getAnnotation(XmlQNameEnum.class)).base() != XmlQNameEnum.BaseType.URI) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is supposed to be converted to a QName (not URI).");
        }
        Enum defaultValue = null;
        for (Map.Entry<? extends Enum, QName> qNameEntry : qNameMap.entrySet()) {
            String uri = qNameEntry.getValue().getNamespaceURI() + qNameEntry.getValue().getLocalPart();
            if (uri.equals(uriValue)) {
                return (Q)qNameEntry.getKey();
            }
            if (defaultValue != null || !UNKNOWN_QNAME_ENUM.equals(qNameEntry.getValue())) continue;
            defaultValue = qNameEntry.getKey();
        }
        return (Q)defaultValue;
    }

    public static String toURI(Enum<?> e) {
        return QNameEnumUtil.toURI(e, QNameEnumUtil.getDefaultBaseUri());
    }

    public static String toURI(Enum<?> e, String defaultBaseUri) {
        QName result;
        if (e == null) {
            return null;
        }
        if (!e.getDeclaringClass().isEnum()) {
            throw new IllegalArgumentException(String.format("Class %s isn't a QName enum.", e.getDeclaringClass().getName()));
        }
        Class<?> clazz = e.getDeclaringClass();
        XmlQNameEnum enumInfo = clazz.getAnnotation(XmlQNameEnum.class);
        if (enumInfo.base() != XmlQNameEnum.BaseType.URI) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is supposed to be converted to a QName (not URI).");
        }
        Map<? extends Enum, QName> qNameMap = QNAME_CACHE.get(clazz);
        if (qNameMap == null) {
            qNameMap = QNameEnumUtil.createQNameMap(clazz);
            QNAME_CACHE.put(clazz, qNameMap);
        }
        if ((result = qNameMap.get(e)) == null) {
            throw new IllegalStateException("Unable to find " + e.getDeclaringClass().getName() + "." + e + " as a QName enum value.");
        }
        if (UNKNOWN_QNAME_ENUM.equals(result)) {
            throw new IllegalArgumentException(e.getDeclaringClass().getName() + "." + e + " is not a QName enum value.");
        }
        if (EXCLUDED_QNAME_ENUM.equals(result)) {
            throw new IllegalArgumentException(e.getDeclaringClass().getName() + "." + e + " is excluded a QName enum value.");
        }
        if (result.getNamespaceURI().equals(defaultBaseUri) && QNameEnumUtil.isWriteRelativeUris()) {
            return result.getLocalPart();
        }
        return result.getNamespaceURI() + result.getLocalPart();
    }

    private static <Q extends Enum<Q>> Map<? extends Enum, QName> createQNameMap(Class<Q> clazz) {
        Package pkg;
        EnumMap<Q, QName> enumQNameEnumMap = new EnumMap<Q, QName>(clazz);
        XmlQNameEnum enumInfo = clazz.getAnnotation(XmlQNameEnum.class);
        if (enumInfo == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " isn't a QName enum.");
        }
        String namespace = enumInfo.namespace();
        if ("##default".equals(namespace) && (pkg = clazz.getPackage()) != null) {
            XmlSchema schemaInfo = pkg.getAnnotation(XmlSchema.class);
            namespace = schemaInfo.namespace();
        }
        Field[] fields = clazz.getDeclaredFields();
        block0: for (Enum e : (Enum[])clazz.getEnumConstants()) {
            for (Field field : fields) {
                if (!field.isEnumConstant() || !field.getName().equals(e.name())) continue;
                if (field.getAnnotation(XmlUnknownQNameEnumValue.class) != null) {
                    enumQNameEnumMap.put(e, UNKNOWN_QNAME_ENUM);
                    continue block0;
                }
                XmlQNameEnumValue enumValueInfo = field.getAnnotation(XmlQNameEnumValue.class);
                String ns = namespace;
                String localPart = field.getName();
                if (enumValueInfo != null) {
                    if (enumValueInfo.exclude()) {
                        enumQNameEnumMap.put(e, EXCLUDED_QNAME_ENUM);
                        continue block0;
                    }
                    if (!"##default".equals(enumValueInfo.namespace())) {
                        ns = enumValueInfo.namespace();
                    }
                    if (!"##default".equals(enumValueInfo.localPart())) {
                        localPart = enumValueInfo.localPart();
                    }
                }
                enumQNameEnumMap.put(e, new QName(ns, localPart));
            }
        }
        return enumQNameEnumMap;
    }
}

