/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.element;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertySpec;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class ElementUtils {
    private ElementUtils() {
    }

    public static String findDeprecationMessage(DecoratedElement<?> el, JavaDocTagHandler tagHandler) {
        JavaDoc.JavaDocTagList tagList;
        Deprecated deprecation = el.getAnnotation(Deprecated.class);
        String message = null;
        if (deprecation != null) {
            message = "";
        }
        if ((tagList = (JavaDoc.JavaDocTagList)el.getJavaDoc(tagHandler).get("deprecated")) != null) {
            message = tagList.toString();
        }
        return message;
    }

    public static boolean isCollection(TypeElement declaration) {
        if (declaration != null) {
            String fqn = declaration.getQualifiedName().toString();
            if (Collection.class.getName().equals(fqn)) {
                return true;
            }
            if (Object.class.getName().equals(fqn)) {
                return false;
            }
            TypeMirror superclass = declaration.getSuperclass();
            if (superclass instanceof DeclaredType && ElementUtils.isCollection((TypeElement)((DeclaredType)superclass).asElement())) {
                return true;
            }
            for (TypeMirror typeMirror : declaration.getInterfaces()) {
                if (!(typeMirror instanceof DeclaredType) || !ElementUtils.isCollection((TypeElement)((DeclaredType)typeMirror).asElement())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMap(TypeElement declaration) {
        if (declaration != null) {
            String fqn = declaration.getQualifiedName().toString();
            if (Map.class.getName().equals(fqn)) {
                return true;
            }
            if (Object.class.getName().equals(fqn)) {
                return false;
            }
            TypeMirror superclass = declaration.getSuperclass();
            if (superclass instanceof DeclaredType && ElementUtils.isMap((TypeElement)((DeclaredType)superclass).asElement())) {
                return true;
            }
            for (TypeMirror typeMirror : declaration.getInterfaces()) {
                if (!(typeMirror instanceof DeclaredType) || !ElementUtils.isMap((TypeElement)((DeclaredType)typeMirror).asElement())) continue;
                return true;
            }
        }
        return false;
    }

    public static String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static class DefaultPropertySpec
    implements PropertySpec {
        protected final DecoratedProcessingEnvironment env;

        public DefaultPropertySpec(DecoratedProcessingEnvironment env) {
            this.env = env;
        }

        @Override
        public boolean isGetter(DecoratedExecutableElement executable) {
            return executable.isPublic() && executable.isGetter();
        }

        @Override
        public boolean isSetter(DecoratedExecutableElement executable) {
            return executable.isPublic() && executable.isSetter();
        }

        @Override
        public String getPropertyName(DecoratedExecutableElement method) {
            return method.getPropertyName();
        }

        @Override
        public boolean isPaired(DecoratedExecutableElement getter, DecoratedExecutableElement setter) {
            if (getter == null) {
                return false;
            }
            if (!this.isGetter(getter)) {
                return false;
            }
            if (getter.getParameters().size() != 0) {
                return false;
            }
            if (setter != null) {
                if (!this.isSetter(setter)) {
                    return false;
                }
                if (!this.getPropertyName(getter).equals(this.getPropertyName(setter))) {
                    return false;
                }
                List<? extends VariableElement> setterParams = setter.getParameters();
                if (setterParams == null || setterParams.size() != 1 || !this.env.getTypeUtils().isSameType(getter.getReturnType(), setterParams.iterator().next().asType())) {
                    return false;
                }
            }
            return true;
        }
    }
}

