/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;

public class MessageDigestUtil {
    private MessageDigestUtil() {
    }

    @NotNull
    public static MessageDigest createMessageDigest(@NotNull String hashAlgorithm) {
        try {
            switch (hashAlgorithm) {
                case "S256": {
                    return MessageDigest.getInstance("SHA-256");
                }
                case "S384": {
                    return MessageDigest.getInstance("SHA-384");
                }
                case "S512": {
                    return MessageDigest.getInstance("SHA-512");
                }
            }
            return MessageDigest.getInstance(hashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NotNull
    public static MessageDigest createSHA256() {
        return MessageDigestUtil.createMessageDigest("SHA-256");
    }
}

