/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.trustworthiness.self;

import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import com.webauthn4j.validator.exception.SelfAttestationProhibitedException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultSelfAttestationTrustworthinessValidator
implements SelfAttestationTrustworthinessValidator {
    private boolean isSelfAttestationAllowed = true;

    @Override
    public void validate(@NonNull CertificateBaseAttestationStatement attestationStatement) {
        AssertUtil.notNull((Object)attestationStatement, (String)"attestationStatement must not be null");
        if (!this.isSelfAttestationAllowed()) {
            throw new SelfAttestationProhibitedException("SELF attestations is prohibited by configuration");
        }
        if (attestationStatement.getX5c() != null) {
            throw new BadAttestationStatementException("SELF attestation must not have x5c.");
        }
    }

    public boolean isSelfAttestationAllowed() {
        return this.isSelfAttestationAllowed;
    }

    public void setSelfAttestationAllowed(boolean selfAttestationAllowed) {
        this.isSelfAttestationAllowed = selfAttestationAllowed;
    }
}

