/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.MessageDigestUtil;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.router.PreserveOnRefresh;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.communication.ReturnChannelHandler;
import com.vaadin.flow.server.communication.rpc.AttachExistingElementRpcHandler;
import com.vaadin.flow.server.communication.rpc.AttachTemplateChildRpcHandler;
import com.vaadin.flow.server.communication.rpc.EventRpcHandler;
import com.vaadin.flow.server.communication.rpc.MapSyncRpcHandler;
import com.vaadin.flow.server.communication.rpc.NavigationRpcHandler;
import com.vaadin.flow.server.communication.rpc.PublishedServerEventHandlerRpcHandler;
import com.vaadin.flow.server.communication.rpc.RpcInvocationHandler;
import com.vaadin.flow.server.dau.DAUUtils;
import com.vaadin.flow.server.dau.FlowDauIntegration;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRpcHandler
implements Serializable {
    public void handleRpc(UI ui, Reader reader, VaadinRequest request) throws IOException, InvalidUIDLSecurityKeyException {
        this.handleRpc(ui, SynchronizedRequestHandler.getRequestBody(reader), request);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleRpc(UI ui, String message, VaadinRequest request) throws InvalidUIDLSecurityKeyException {
        ui.getSession().setLastRequestTimestamp(System.currentTimeMillis());
        if (message == null) return;
        if (message.isEmpty()) {
            return;
        }
        RpcRequest rpcRequest = new RpcRequest(message, request.getService().getDeploymentConfiguration().isSyncIdCheckEnabled());
        if (!VaadinService.isCsrfTokenValid(ui, rpcRequest.getCsrfToken())) {
            throw new InvalidUIDLSecurityKeyException();
        }
        String hashMessage = message;
        if (hashMessage.length() > 65536) {
            hashMessage = message.substring(0, 65536);
        }
        byte[] messageHash = MessageDigestUtil.sha256(hashMessage);
        int expectedId = ui.getInternals().getLastProcessedClientToServerId() + 1;
        int requestId = rpcRequest.getClientToServerId();
        if (requestId != -1 && requestId != expectedId) {
            if (requestId == expectedId - 1 && Arrays.equals(messageHash, ui.getInternals().getLastProcessedMessageHash())) {
                ServerRpcHandler.getLogger().info("Ignoring old duplicate message from the client. Expected: " + expectedId + ", got: " + requestId);
            } else {
                if (!rpcRequest.isUnloadBeaconRequest()) {
                    String messageDetails = this.getMessageDetails(rpcRequest);
                    ServerRpcHandler.getLogger().debug("Unexpected message id from the client. Expected client id: " + expectedId + ", got " + requestId + ". Message start: " + messageDetails);
                    throw new UnsupportedOperationException("Unexpected message id from the client. Expected client id: " + expectedId + ", got " + requestId + ". more details logged on DEBUG level.");
                }
                ServerRpcHandler.getLogger().debug("Ignoring unexpected message id from the client on UNLOAD request. This could happen for example during login process, if concurrent requests are sent to the server and one of those changes the session identifier, causing an UIDL request to be rejected because of session expiration. Expected client id: {}, got {}.", (Object)expectedId, (Object)requestId);
            }
        } else {
            ui.getInternals().setLastProcessedClientToServerId(expectedId, messageHash);
            this.enforceIfNeeded(request, rpcRequest);
            this.handleInvocations(ui, rpcRequest.getRpcInvocationsData());
        }
        if (rpcRequest.isResynchronize()) {
            ServerRpcHandler.getLogger().warn("Resynchronizing UI by client's request. A network message was lost before reaching the client and the client is reloading the full UI state. This typically happens because of a bad network connection with packet loss or because of some part of the network infrastructure (load balancer, proxy) terminating a push (websocket or long-polling) connection. If you are using push with a proxy, make sure the push timeout is set to be smaller than the proxy connection timeout");
            if (request.getWrappedSession().getAttributeNames().stream().anyMatch(name -> name.startsWith("com.vaadin.server.VaadinSession"))) {
                ServerRpcHandler.getLogger().warn("MPR is in use, so full page reload will be done to achieve re-sync.");
                ui.getPage().reload();
                return;
            }
            ui.getInternals().getStateTree().prepareForResync();
            ui.getInternals().getDependencyList().clearPendingSendToClient();
            throw new ResynchronizationRequiredException();
        }
        if (!rpcRequest.isUnloadBeaconRequest()) return;
        if (ServerRpcHandler.isPreserveOnRefreshTarget(ui)) {
            ServerRpcHandler.getLogger().debug("Eager UI close ignored for @PreserveOnRefresh view");
            return;
        }
        ui.close();
        ServerRpcHandler.getLogger().debug("UI closed with a beacon request");
    }

    private void enforceIfNeeded(VaadinRequest request, RpcRequest rpcRequest) {
        if (DAUUtils.isDauEnabled(request.getService())) {
            FlowDauIntegration.applyEnforcement(request, this.shouldApplyEnforcement(rpcRequest));
        }
    }

    private Predicate<VaadinRequest> shouldApplyEnforcement(RpcRequest rpcRequest) {
        return request -> {
            if (rpcRequest.isUnloadBeaconRequest()) {
                return false;
            }
            if (rpcRequest.isResynchronize()) {
                return false;
            }
            JsonArray invocations = rpcRequest.getRpcInvocationsData();
            if (invocations == null) {
                return false;
            }
            for (int i = 0; i < invocations.length(); ++i) {
                String event;
                JsonObject json = (JsonObject)invocations.get(i);
                String type = json.hasKey("type") ? json.getString("type") : "";
                String string = event = json.hasKey("event") ? json.getString("event") : "";
                if ("channel".equals(type) || "event".equals(type) && "ui-poll".equals(event)) continue;
                return true;
            }
            return false;
        };
    }

    private static boolean isPreserveOnRefreshTarget(UI ui) {
        return ui.getInternals().getActiveRouterTargetsChain().stream().anyMatch(rt -> rt.getClass().isAnnotationPresent(PreserveOnRefresh.class));
    }

    private String getMessageDetails(RpcRequest rpcRequest) {
        StringBuilder messageDetails = new StringBuilder();
        JsonArray rpcArray = rpcRequest.getRpcInvocationsData();
        if (rpcArray == null) {
            return "{ no data }";
        }
        for (int i = 0; i < rpcArray.length(); ++i) {
            JsonObject json = (JsonObject)rpcArray.get(i);
            String type = json.hasKey("type") ? json.getString("type") : "";
            Double node = json.hasKey("node") ? Double.valueOf(json.getNumber("node")) : null;
            Double feature = json.hasKey("feature") ? Double.valueOf(json.getNumber("feature")) : null;
            ServerRpcHandler.appendAll(messageDetails, "{ type: ", type, " node: ", String.valueOf(node), " feature: ", String.valueOf(feature), " } ");
        }
        return messageDetails.toString();
    }

    private static void appendAll(StringBuilder builder, String ... strings) {
        for (String string : strings) {
            builder.append(string);
        }
    }

    protected Map<String, RpcInvocationHandler> getInvocationHandlers() {
        return Collections.unmodifiableMap(LazyInvocationHandlers.HANDLERS);
    }

    private void handleInvocations(UI ui, JsonArray invocationsData) {
        ArrayList<JsonObject> data = new ArrayList<JsonObject>(invocationsData.length());
        ArrayList pendingChangeEvents = new ArrayList();
        RpcInvocationHandler mapSyncHandler = this.getInvocationHandlers().get("mSync");
        for (int i = 0; i < invocationsData.length(); ++i) {
            JsonObject invocationJson = invocationsData.getObject(i);
            String type = invocationJson.getString("type");
            assert (type != null);
            if ("mSync".equals(type)) {
                mapSyncHandler.handle(ui, invocationJson).ifPresent(runnable -> pendingChangeEvents.add(() -> {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        ServerRpcHandler.callErrorHandler(ui, invocationJson, throwable);
                    }
                }));
                continue;
            }
            data.add(invocationJson);
        }
        pendingChangeEvents.forEach(runnable -> this.runMapSyncTask(ui, (Runnable)runnable));
        data.forEach(json -> this.handleInvocationData(ui, (JsonObject)json));
    }

    private void runMapSyncTask(UI ui, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            ui.getSession().getErrorHandler().error(new ErrorEvent(throwable));
        }
    }

    private void handleInvocationData(UI ui, JsonObject invocationJson) {
        String type = invocationJson.getString("type");
        RpcInvocationHandler handler = this.getInvocationHandlers().get(type);
        if (handler == null) {
            throw new IllegalArgumentException("Unsupported event type: " + type);
        }
        try {
            Optional<Runnable> handle = handler.handle(ui, invocationJson);
            assert (!handle.isPresent()) : "RPC handler " + handler.getClass().getName() + " returned a Runnable even though it shouldn't";
        }
        catch (Throwable throwable) {
            ServerRpcHandler.callErrorHandler(ui, invocationJson, throwable);
        }
    }

    private static void callErrorHandler(UI ui, JsonObject invocationJson, Throwable throwable) {
        StateNode node = ui.getInternals().getStateTree().getNodeById((int)invocationJson.getNumber("node"));
        ErrorEvent event = node != null ? new ErrorEvent(throwable, node) : new ErrorEvent(throwable);
        ui.getSession().getErrorHandler().error(event);
    }

    protected String getMessage(Reader reader) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder(65536);
        char[] buffer = new char[65536];
        while ((read = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, read);
        }
        return sb.toString();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ServerRpcHandler.class.getName());
    }

    private static RpcInvocationHandler resolveHandlerConflicts(RpcInvocationHandler handler1, RpcInvocationHandler handler2) {
        String msg = String.format("There are two Rpc invocation handlers for the same type '%s' : '%s and %s", handler1.getRpcType(), handler1.getClass().getName(), handler2.getClass().getName());
        throw new IllegalStateException(msg);
    }

    public static class RpcRequest
    implements Serializable {
        private final String csrfToken;
        private final JsonArray invocations;
        private final int syncId;
        private final JsonObject json;
        private final boolean resynchronize;
        private final int clientToServerMessageId;

        public RpcRequest(String jsonString, VaadinRequest request) {
            this(jsonString, request.getService().getDeploymentConfiguration().isSyncIdCheckEnabled());
        }

        public RpcRequest(String jsonString, boolean isSyncIdCheckEnabled) {
            this.json = (JsonObject)JsonUtil.parse((String)jsonString);
            JsonValue token = this.json.get("csrfToken");
            if (token == null) {
                this.csrfToken = "init";
            } else {
                String csrfToken = token.asString();
                if (csrfToken.equals("")) {
                    csrfToken = "init";
                }
                this.csrfToken = csrfToken;
            }
            this.syncId = isSyncIdCheckEnabled ? (int)this.json.getNumber("syncId") : -1;
            this.resynchronize = this.json.hasKey("resynchronize") ? this.json.getBoolean("resynchronize") : false;
            if (this.json.hasKey("clientId")) {
                this.clientToServerMessageId = (int)this.json.getNumber("clientId");
            } else {
                ServerRpcHandler.getLogger().warn("Server message without client id received");
                this.clientToServerMessageId = -1;
            }
            this.invocations = this.json.getArray("rpc");
        }

        public String getCsrfToken() {
            return this.csrfToken;
        }

        public JsonArray getRpcInvocationsData() {
            return this.invocations;
        }

        public int getSyncId() {
            return this.syncId;
        }

        public boolean isResynchronize() {
            return this.resynchronize;
        }

        public int getClientToServerId() {
            return this.clientToServerMessageId;
        }

        public JsonObject getRawJson() {
            return this.json;
        }

        private boolean isUnloadBeaconRequest() {
            return this.json.hasKey("UNLOAD");
        }
    }

    public static class InvalidUIDLSecurityKeyException
    extends GeneralSecurityException {
    }

    public static class ResynchronizationRequiredException
    extends RuntimeException {
    }

    private static class LazyInvocationHandlers {
        private static final Map<String, RpcInvocationHandler> HANDLERS = LazyInvocationHandlers.loadHandlers().stream().collect(Collectors.toMap(RpcInvocationHandler::getRpcType, Function.identity(), ServerRpcHandler::resolveHandlerConflicts, HashMap::new));

        private LazyInvocationHandlers() {
        }

        private static List<RpcInvocationHandler> loadHandlers() {
            ArrayList<RpcInvocationHandler> list = new ArrayList<RpcInvocationHandler>();
            list.add(new EventRpcHandler());
            list.add(new NavigationRpcHandler());
            list.add(new MapSyncRpcHandler());
            list.add(new PublishedServerEventHandlerRpcHandler());
            list.add(new AttachExistingElementRpcHandler());
            list.add(new AttachTemplateChildRpcHandler());
            list.add(new ReturnChannelHandler());
            return list;
        }
    }
}

