/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TreeData<T>
implements Serializable {
    private final Map<T, HierarchyWrapper<T>> itemToWrapperMap = new LinkedHashMap<T, HierarchyWrapper<T>>();

    public TreeData() {
        this.itemToWrapperMap.put(null, new HierarchyWrapper<Object>(null));
    }

    public TreeData<T> addRootItems(T ... items) {
        this.addItems(null, items);
        return this;
    }

    public TreeData<T> addRootItems(Collection<T> items) {
        this.addItems((T)null, items);
        return this;
    }

    public TreeData<T> addRootItems(Stream<T> items) {
        this.addItems((T)null, items);
        return this;
    }

    public TreeData<T> addItem(T parent, T item) {
        Objects.requireNonNull(item, "Item cannot be null");
        if (parent != null && !this.contains(parent)) {
            throw new IllegalArgumentException("Parent needs to be added before children. To add root items, call with parent as null");
        }
        if (this.contains(item)) {
            throw new IllegalArgumentException("Cannot add the same item multiple times: " + item);
        }
        this.putItem(item, parent);
        return this;
    }

    public TreeData<T> addItems(T parent, T ... items) {
        Arrays.stream(items).forEach(item -> this.addItem(parent, item));
        return this;
    }

    public TreeData<T> addItems(T parent, Collection<T> items) {
        items.forEach(item -> this.addItem(parent, item));
        return this;
    }

    public TreeData<T> addItems(T parent, Stream<T> items) {
        items.forEach(item -> this.addItem(parent, item));
        return this;
    }

    public TreeData<T> addItems(Collection<T> rootItems, ValueProvider<T, Collection<T>> childItemProvider) {
        rootItems.forEach(item -> {
            this.addItem(null, item);
            Collection childItems = (Collection)childItemProvider.apply(item);
            this.addItems(item, childItems);
            this.addItemsRecursively(childItems, childItemProvider);
        });
        return this;
    }

    public TreeData<T> addItems(Stream<T> rootItems, ValueProvider<T, Stream<T>> childItemProvider) {
        return this.addItems(rootItems.collect(Collectors.toList()), (ValueProvider<T, Collection<T>>)(ValueProvider & Serializable)item -> ((Stream)childItemProvider.apply(item)).collect(Collectors.toList()));
    }

    public TreeData<T> removeItem(T item) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + item + "' not in the hierarchy");
        }
        new ArrayList<T>(this.getChildren(item)).forEach(child -> this.removeItem(child));
        this.itemToWrapperMap.get(this.itemToWrapperMap.get(item).getParent()).removeChild(item);
        if (item != null) {
            this.itemToWrapperMap.remove(item);
        }
        return this;
    }

    public TreeData<T> clear() {
        this.removeItem(null);
        return this;
    }

    public List<T> getRootItems() {
        return this.getChildren(null);
    }

    public List<T> getChildren(T item) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + item + "' not in the hierarchy");
        }
        return Collections.unmodifiableList(this.itemToWrapperMap.get(item).getChildren());
    }

    public T getParent(T item) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + item + "' not in hierarchy");
        }
        return this.itemToWrapperMap.get(item).getParent();
    }

    public void setParent(T item, T parent) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + item + "' not in the hierarchy");
        }
        if (parent != null && !this.contains(parent)) {
            throw new IllegalArgumentException("Parent needs to be added before children. To set as root item, call with parent as null");
        }
        if (item.equals(parent)) {
            throw new IllegalArgumentException("Item cannot be the parent of itself");
        }
        T oldParent = this.itemToWrapperMap.get(item).getParent();
        if (!Objects.equals(oldParent, parent)) {
            this.itemToWrapperMap.get(oldParent).removeChild(item);
            this.itemToWrapperMap.get(parent).addChild(item);
            this.itemToWrapperMap.get(item).setParent(parent);
        }
    }

    public void moveAfterSibling(T item, T sibling) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + item + "' not in the hierarchy");
        }
        if (sibling == null) {
            List<T> children = this.itemToWrapperMap.get(this.getParent(item)).getChildren();
            children.remove(item);
            children.add(0, item);
        } else {
            if (!this.contains(sibling)) {
                throw new IllegalArgumentException("Item '" + sibling + "' not in the hierarchy");
            }
            T parent = this.itemToWrapperMap.get(item).getParent();
            if (!Objects.equals(parent, this.itemToWrapperMap.get(sibling).getParent())) {
                throw new IllegalArgumentException("Items '" + item + "' and '" + sibling + "' don't have the same parent");
            }
            List<T> children = this.itemToWrapperMap.get(parent).getChildren();
            children.remove(item);
            children.add(children.indexOf(sibling) + 1, item);
        }
    }

    public boolean contains(T item) {
        return this.itemToWrapperMap.containsKey(item);
    }

    private void putItem(T item, T parent) {
        HierarchyWrapper<T> wrappedItem = new HierarchyWrapper<T>(parent);
        if (this.itemToWrapperMap.containsKey(parent)) {
            this.itemToWrapperMap.get(parent).addChild(item);
        }
        this.itemToWrapperMap.put(item, wrappedItem);
    }

    private void addItemsRecursively(Collection<T> items, ValueProvider<T, Collection<T>> childItemProvider) {
        items.forEach(item -> {
            Collection childItems = (Collection)childItemProvider.apply(item);
            this.addItems(item, childItems);
            this.addItemsRecursively(childItems, childItemProvider);
        });
    }

    private static class HierarchyWrapper<T>
    implements Serializable {
        private T parent;
        private List<T> children;

        public HierarchyWrapper(T parent) {
            this.parent = parent;
            this.children = new ArrayList<T>();
        }

        public T getParent() {
            return this.parent;
        }

        public void setParent(T parent) {
            this.parent = parent;
        }

        public List<T> getChildren() {
            return this.children;
        }

        public void addChild(T child) {
            this.children.add(child);
        }

        public void removeChild(T child) {
            this.children.remove(child);
        }
    }
}

