/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.Rtf;
import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfPara;
import com.tutego.jrtf.RtfPicture;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class RtfText {
    private final CharSequence rtf;

    RtfText(CharSequence rtf) {
        this.rtf = rtf;
    }

    void rtf(Appendable out) throws IOException {
        out.append(this.rtf);
    }

    public static RtfText text(Object ... texts) {
        return RtfText.textJoinWithSpace(false, texts);
    }

    public static RtfText textJoinWithSpace(boolean joinWithSpace, Object ... texts) {
        if (texts == null || texts.length == 0) {
            return new RtfText("");
        }
        StringBuilder result = new StringBuilder(1024);
        for (int i = 0; i < texts.length; ++i) {
            if (texts[i] == null) continue;
            if (joinWithSpace && i > 0 && texts[i - 1] != null) {
                result.append(' ');
            }
            try {
                if (texts[i] instanceof RtfText) {
                    ((RtfText)texts[i]).rtf(result);
                    continue;
                }
                if (texts[i] instanceof RtfPara) {
                    throw new RtfException("RtfPara in method text() is not allowed. There is no sensible toString() method declared");
                }
                Rtf.asRtf(result, texts[i].toString());
                continue;
            }
            catch (IOException e) {
                throw new RtfException(e);
            }
        }
        return new RtfText(result);
    }

    public static RtfText text(String text) {
        if (text == null) {
            text = "";
        }
        return new RtfText(Rtf.asRtf(text));
    }

    public static RtfText font(int fontnum, Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 8);
        sb.append("{\\f").append(fontnum).append(' ').append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText italic(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 5);
        sb.append("{\\i ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText bold(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 5);
        sb.append("{\\b ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText underline(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 6);
        sb.append("{\\ul ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText dottedUnderline(String text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 7);
        sb.append("{\\uld ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText doubleUnderline(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 8);
        sb.append("{\\uldb ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText wordUnderline(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 7);
        sb.append("{\\ulw ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText subscript(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 7);
        sb.append("{\\sub ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText revised(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 11);
        sb.append("{\\revised ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText superscript(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 9);
        sb.append("{\\super ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText strikethru(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 10);
        sb.append("{\\strike ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText shadow(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 8);
        sb.append("{\\shad ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText smallCapitals(Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 9);
        sb.append("{\\scaps ").append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText fontSize(int fontSize, Object text) {
        if (fontSize < 0) {
            throw new IllegalArgumentException("Font size can't be negative");
        }
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 10);
        sb.append("{\\fs").append(fontSize).append(' ').append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText color(int colorindex, Object text) {
        RtfText rtfText = RtfText.text(text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 10);
        sb.append("{\\cf").append(colorindex).append(' ').append(rtfText.rtf).append('}');
        return new RtfText(sb);
    }

    public static RtfText color(int colorindex, String text) {
        return RtfText.color(colorindex, RtfText.text(text));
    }

    public static RtfText currentDate() {
        return new RtfText("\\chdate\n");
    }

    public static RtfText currentDateLong() {
        return new RtfText("\\chdpl\n");
    }

    public static RtfText currentDateAbbreviated() {
        return new RtfText("\\chdpa\n");
    }

    public static RtfText currentTime() {
        return new RtfText("\\chtime\n");
    }

    public static RtfText currentPageNumber() {
        return new RtfText("\\chpgn\n");
    }

    public static RtfText currentSectionNumber() {
        return new RtfText("\\sectnum\n");
    }

    public static RtfText pageBreak() {
        return new RtfText("\\page\n");
    }

    public static RtfText columnBreak() {
        return new RtfText("\\column\n");
    }

    public static RtfText lineBreak() {
        return new RtfText("\\line\n");
    }

    public static RtfText softPageBreak() {
        return new RtfText("\\softpage\n");
    }

    public static RtfText softColumnBreak() {
        return new RtfText("\\softcol\n");
    }

    public static RtfText softLineBreak() {
        return new RtfText("\\softline\n");
    }

    public static RtfText tab() {
        return new RtfText("\\tab\n");
    }

    public static RtfText longHyphen() {
        return new RtfText("\\emdash\n");
    }

    public static RtfText shortHyphen() {
        return new RtfText("\\endash\n");
    }

    public static RtfText bullet() {
        return new RtfText("\\bullet\n");
    }

    public static RtfText leftQuotationMark() {
        return new RtfText("\\lquote\n");
    }

    public static RtfText rightQuotationMark() {
        return new RtfText("\\rquote\n");
    }

    public static RtfText qoute(Object text) {
        RtfText rtfText = RtfText.text(text);
        return new RtfText("\\lquote\n" + rtfText.rtf + "\\rquote\n");
    }

    public static RtfText leftDoubleQuotationMark() {
        return new RtfText("\\ldblquote\n");
    }

    public static RtfText rightDoubleQuotationMark() {
        return new RtfText("\\rdblquote\n");
    }

    public static RtfText doubleQuote(Object text) {
        RtfText rtfText = RtfText.text(text);
        return new RtfText("\\ldblquote\n" + rtfText.rtf + "\\rdblquote\n");
    }

    public static RtfText nonBreakingSpace() {
        return new RtfText("\\~\n");
    }

    public static RtfPicture picture(URL source) {
        try {
            return new RtfPicture(source.openStream());
        }
        catch (IOException e) {
            throw new RtfException(e);
        }
    }

    public static RtfPicture picture(InputStream source) {
        try {
            return new RtfPicture(source);
        }
        catch (IOException e) {
            throw new RtfException(e);
        }
    }

    public static RtfText footnote(final RtfPara ... paras) {
        return new RtfText(null){

            @Override
            void rtf(Appendable out) throws IOException {
                out.append("\\chftn{\\footnote{\\up6\\chftn }");
                for (RtfPara rtfPara : paras) {
                    rtfPara.rtf(out, false);
                }
                out.append("}\n");
            }
        };
    }

    public static RtfText footnote(Object para) {
        return RtfText.footnote((Object)RtfPara.p(para));
    }

    public static RtfText field(final RtfPara fieldInstructions, final RtfPara recentResult, final FieldModifier fieldModifier) {
        if (fieldInstructions == null) {
            throw new IllegalArgumentException("Field instructions are missing");
        }
        return new RtfText(null){

            @Override
            void rtf(Appendable out) throws IOException {
                out.append("{\\field");
                if (fieldModifier != null) {
                    out.append(fieldModifier.toString());
                }
                out.append("{\\*\\fldinst ");
                fieldInstructions.rtf(out, false);
                out.append("}{\\fldrslt ");
                if (recentResult != null) {
                    recentResult.rtf(out, false);
                }
                out.append("}}");
            }
        };
    }

    public static RtfText field(RtfPara fieldInstructions, RtfPara recentResult) {
        return RtfText.field(fieldInstructions, recentResult, null);
    }

    public static RtfText hyperlink(String url, RtfPara text) {
        try {
            StringBuilder sb = new StringBuilder(256);
            sb.append("{\\field{\\*\\fldinst{HYPERLINK \"").append(Rtf.asRtf(url)).append("\"}}{\\fldrslt{\\ul ");
            text.rtf(sb, false);
            sb.append("}}}");
            return new RtfText(sb);
        }
        catch (IOException e) {
            throw new RtfException(e);
        }
    }

    public static enum FieldModifier {
        DIRTY{

            public String toString() {
                return "\\flddirty";
            }
        }
        ,
        EDITED{

            public String toString() {
                return "\\fldedit";
            }
        }
        ,
        LOCKED{

            public String toString() {
                return "\\fldlock";
            }
        }
        ,
        NONDISPLAYABLE{

            public String toString() {
                return "\\fldpriv";
            }
        };

    }
}

