/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.Rtf;
import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfPara;
import com.tutego.jrtf.RtfUnit;

public class RtfSectionFormatAndHeaderFooter {
    final CharSequence rtf;

    private RtfSectionFormatAndHeaderFooter(CharSequence rtf) {
        this.rtf = rtf;
    }

    public static RtfSectionFormatAndHeaderFooter sectionFormatting(RtfSectionFormatAndHeaderFooter ... sectionFormats) {
        StringBuilder sb = new StringBuilder(sectionFormats.length * 10);
        for (RtfSectionFormatAndHeaderFooter rtfSectionFormat : sectionFormats) {
            sb.append(rtfSectionFormat.rtf);
        }
        return new RtfSectionFormatAndHeaderFooter(sb);
    }

    public static RtfSectionFormatAndHeaderFooter reset() {
        return new RtfSectionFormatAndHeaderFooter("\\sectd");
    }

    public static RtfSectionFormatAndHeaderFooter endnotesIncluded() {
        return new RtfSectionFormatAndHeaderFooter("\\endnhere");
    }

    public static RtfSectionFormatAndHeaderFooter noBreak() {
        return new RtfSectionFormatAndHeaderFooter("\\sbknone");
    }

    public static RtfSectionFormatAndHeaderFooter breakStartsNewColumn() {
        return new RtfSectionFormatAndHeaderFooter("\\sbkcol");
    }

    public static RtfSectionFormatAndHeaderFooter breakStartsNewPage() {
        return new RtfSectionFormatAndHeaderFooter("\\sbkpage");
    }

    public static RtfSectionFormatAndHeaderFooter breakStartsNewEvenPage() {
        return new RtfSectionFormatAndHeaderFooter("\\sbkeven");
    }

    public static RtfSectionFormatAndHeaderFooter breakStartsNewOddPage() {
        return new RtfSectionFormatAndHeaderFooter("\\sbkodd");
    }

    public static RtfSectionFormatAndHeaderFooter columns(int columns) {
        if (columns <= 0) {
            throw new RtfException("Number of colums can't be <= 0");
        }
        return new RtfSectionFormatAndHeaderFooter("\\cols" + columns);
    }

    public static RtfSectionFormatAndHeaderFooter spaceBetweenColumns(double space, RtfUnit unit) {
        return new RtfSectionFormatAndHeaderFooter("\\colsx" + unit.toTwips(space));
    }

    public static RtfSectionFormatAndHeaderFooter lineBetweenColumns() {
        return new RtfSectionFormatAndHeaderFooter("\\linebetcol");
    }

    public static RtfSectionFormatAndHeaderFooter beginningPageNumber(int pageNumber) {
        return new RtfSectionFormatAndHeaderFooter("\\pgnstarts" + pageNumber);
    }

    public static RtfSectionFormatAndHeaderFooter topAlignText() {
        return new RtfSectionFormatAndHeaderFooter("\\vertalt");
    }

    public static RtfSectionFormatAndHeaderFooter bottomAlignText() {
        return new RtfSectionFormatAndHeaderFooter("\\vertalb");
    }

    public static RtfSectionFormatAndHeaderFooter centerVerticalText() {
        return new RtfSectionFormatAndHeaderFooter("\\vertalc");
    }

    public static RtfSectionFormatAndHeaderFooter justifyVerticalText() {
        return new RtfSectionFormatAndHeaderFooter("\\vertalj");
    }

    public static RtfSectionFormatAndHeaderFooter headerForAllPages(RtfPara para) {
        return new RtfSectionFormatAndHeaderFooter(Rtf.frameRtfParagraphWithEndingPar("header", para));
    }

    public static RtfSectionFormatAndHeaderFooter headerForLeftHandPages(RtfPara para) {
        return new RtfSectionFormatAndHeaderFooter(Rtf.frameRtfParagraphWithEndingPar("headerl", para));
    }

    public static RtfSectionFormatAndHeaderFooter headerForRightHandPages(RtfPara para) {
        return new RtfSectionFormatAndHeaderFooter(Rtf.frameRtfParagraphWithEndingPar("headerr", para));
    }

    public static RtfSectionFormatAndHeaderFooter headerForFirstPage(RtfPara para) {
        return new RtfSectionFormatAndHeaderFooter(Rtf.frameRtfParagraphWithEndingPar("headerf", para));
    }

    public static RtfSectionFormatAndHeaderFooter footerOnAllPages(RtfPara para) {
        return new RtfSectionFormatAndHeaderFooter(Rtf.frameRtfParagraphWithEndingPar("footer", para));
    }
}

