/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.mojo.antlr4;

import java.io.File;
import org.antlr.v4.Tool;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.tool.ANTLRMessage;
import org.antlr.v4.tool.ANTLRToolListener;
import org.apache.maven.plugin.logging.Log;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.stringtemplate.v4.ST;

public class Antlr4ErrorLog
implements ANTLRToolListener {
    private final Tool tool;
    private final BuildContext buildContext;
    private final Log log;

    public Antlr4ErrorLog(@NotNull Tool tool, @NotNull BuildContext buildContext, @NotNull Log log) {
        this.tool = tool;
        this.buildContext = buildContext;
        this.log = log;
    }

    public void info(String message) {
        if (this.tool.errMgr.formatWantsSingleLineMessage()) {
            message = message.replace('\n', ' ');
        }
        this.log.info((CharSequence)message);
    }

    public void error(ANTLRMessage message) {
        ST msgST = this.tool.errMgr.getMessageTemplate(message);
        String outputMsg = msgST.render();
        if (this.tool.errMgr.formatWantsSingleLineMessage()) {
            outputMsg = outputMsg.replace('\n', ' ');
        }
        this.log.error((CharSequence)outputMsg);
        if (message.fileName != null) {
            String text = message.getMessageTemplate(false).render();
            this.buildContext.addMessage(new File(message.fileName), message.line, message.charPosition, text, 2, message.getCause());
        }
    }

    public void warning(ANTLRMessage message) {
        ST msgST = this.tool.errMgr.getMessageTemplate(message);
        String outputMsg = msgST.render();
        if (this.tool.errMgr.formatWantsSingleLineMessage()) {
            outputMsg = outputMsg.replace('\n', ' ');
        }
        this.log.warn((CharSequence)outputMsg);
        if (message.fileName != null) {
            String text = message.getMessageTemplate(false).render();
            this.buildContext.addMessage(new File(message.fileName), message.line, message.charPosition, text, 1, message.getCause());
        }
    }
}

