/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.util.structures;

import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.util.structures.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Table
extends ArrayList<Row> {
    private List<String> columnNames = new ArrayList<String>();
    private int tableWidth = -1;

    public Table() {
    }

    public Table(String ... columnNames) {
        this();
        this.columnNames.addAll(Arrays.asList(columnNames));
        this.tableWidth = columnNames.length;
    }

    public Table apply(PipeFunction ... functions) {
        if (this.tableWidth != -1 && functions.length == this.tableWidth) {
            Table table = new Table();
            for (Row row : this) {
                ArrayList temp = new ArrayList();
                for (int i = 0; i < row.size(); ++i) {
                    temp.add(functions[i].compute(row.get(i)));
                }
                table.addRow(temp);
            }
            return table;
        }
        throw new RuntimeException("Table width is " + this.tableWidth + " and functions length is " + functions.length);
    }

    public void addRow(List row) {
        if (this.tableWidth == -1) {
            this.tableWidth = row.size();
        } else if (row.size() != this.tableWidth) {
            throw new RuntimeException("Table width is " + this.tableWidth + " and row width is " + row.size());
        }
        this.add(new Row(row, this.getColumnNames()));
    }

    public void addRow(Object ... row) {
        this.addRow(Arrays.asList(row));
    }

    public void setColumnNames(String ... columnNames) {
        if (this.tableWidth != -1 && columnNames.length != this.tableWidth) {
            throw new RuntimeException("Table width is " + this.tableWidth + " and there are " + columnNames.length + " column names");
        }
        this.columnNames.clear();
        this.columnNames.addAll(Arrays.asList(columnNames));
        this.tableWidth = this.columnNames.size();
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public int getRowCount() {
        return this.size();
    }

    public int getColumnCount() {
        return this.tableWidth;
    }

    public Object get(int row, int column) {
        return ((Row)this.get(row)).get(column);
    }

    public Object get(int row, String columnName) {
        return ((Row)this.get(row)).get(this.columnNames.indexOf(columnName));
    }

    public Row getRow(int row) {
        return (Row)this.get(row);
    }

    public List getColumn(int column) {
        ArrayList temp = new ArrayList();
        for (Row row : this) {
            temp.add(row.get(column));
        }
        return temp;
    }

    public List getColumn(String columnName) {
        return this.getColumn(this.columnNames.indexOf(columnName));
    }

    @Override
    public void clear() {
        super.clear();
        this.tableWidth = -1;
        this.columnNames = new ArrayList<String>();
    }
}

