/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.util;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.MetaPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Pipeline<S, E>
implements Pipe<S, E>,
MetaPipe {
    protected Pipe<S, ?> startPipe;
    protected Pipe<?, E> endPipe;
    protected List<Pipe> pipes;
    protected Iterator<S> starts;

    public Pipeline() {
        this.pipes = new ArrayList<Pipe>();
    }

    public Pipeline(List<Pipe> pipes) {
        this.pipes = pipes;
        this.setPipes(pipes);
    }

    public Pipeline(Pipe ... pipes) {
        this(new ArrayList<Pipe>(Arrays.asList(pipes)));
    }

    protected void setPipes(List<Pipe> pipes) {
        this.startPipe = pipes.get(0);
        this.endPipe = pipes.get(pipes.size() - 1);
        for (int i = 1; i < pipes.size(); ++i) {
            pipes.get(i).setStarts(pipes.get(i - 1));
        }
    }

    protected void setPipes(Pipe ... pipes) {
        this.setPipes(Arrays.asList(pipes));
    }

    public void addPipe(Pipe pipe) {
        this.pipes.add(pipe);
        this.setPipes(this.pipes);
    }

    @Override
    public void setStarts(Iterator<S> starts) {
        this.starts = starts;
        this.startPipe.setStarts(starts);
    }

    @Override
    public void setStarts(Iterable<S> starts) {
        this.setStarts(starts.iterator());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.endPipe.hasNext();
    }

    @Override
    public E next() {
        return this.endPipe.next();
    }

    @Override
    public List getPath() {
        return this.endPipe.getPath();
    }

    public int size() {
        return this.pipes.size();
    }

    @Override
    public void reset() {
        this.endPipe.reset();
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    public String toString() {
        return this.pipes.toString();
    }

    @Override
    public List<Pipe> getPipes() {
        return this.pipes;
    }

    public Iterator<S> getStarts() {
        return this.starts;
    }

    public Pipe remove(int index) {
        return this.pipes.remove(index);
    }

    public Pipe get(int index) {
        return this.pipes.get(index);
    }

    public boolean equals(Object object) {
        return object instanceof Pipeline && PipeHelper.areEqual(this, (Pipeline)object);
    }

    public long count() {
        return PipeHelper.counter(this);
    }

    public void iterate() {
        PipeHelper.iterate(this);
    }

    public List<E> next(int number) {
        ArrayList list = new ArrayList(number);
        PipeHelper.fillCollection(this, list, number);
        return list;
    }

    public List<E> toList() {
        ArrayList list = new ArrayList();
        PipeHelper.fillCollection(this, list);
        return list;
    }

    public Collection<E> fill(Collection<E> collection) {
        PipeHelper.fillCollection(this, collection);
        return collection;
    }
}

