/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.util;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.filter.FilterPipe;
import com.tinkerpop.pipes.util.iterators.EmptyIterator;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PipeHelper {
    private PipeHelper() {
    }

    public static <T> void iterate(Iterator<T> iterator) {
        try {
            while (true) {
                iterator.next();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public static <T> void fillCollection(Iterator<T> iterator, Collection<T> collection) {
        try {
            while (true) {
                collection.add(iterator.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public static <T> void fillCollection(Iterator<T> iterator, Collection<T> collection, int number) {
        try {
            for (int i = 0; i < number; ++i) {
                collection.add(iterator.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static long counter(Iterator iterator) {
        long counter = 0L;
        try {
            while (true) {
                iterator.next();
                ++counter;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return counter;
        }
    }

    public static boolean areEqual(Iterator ittyA, Iterator ittyB) {
        if (ittyA.hasNext() != ittyB.hasNext()) {
            return false;
        }
        while (ittyA.hasNext()) {
            if (!ittyB.hasNext()) {
                return false;
            }
            if (ittyA.next() == ittyB.next()) continue;
            return false;
        }
        return true;
    }

    public static boolean compareObjects(FilterPipe.Filter filter, Object leftObject, Object rightObject) {
        switch (filter) {
            case EQUAL: {
                if (null == leftObject) {
                    return rightObject == null;
                }
                return leftObject.equals(rightObject);
            }
            case NOT_EQUAL: {
                if (null == leftObject) {
                    return rightObject != null;
                }
                return !leftObject.equals(rightObject);
            }
            case GREATER_THAN: {
                if (null == leftObject || rightObject == null) {
                    return false;
                }
                return ((Comparable)leftObject).compareTo(rightObject) == 1;
            }
            case LESS_THAN: {
                if (null == leftObject || rightObject == null) {
                    return false;
                }
                return ((Comparable)leftObject).compareTo(rightObject) == -1;
            }
            case GREATER_THAN_EQUAL: {
                if (null == leftObject || rightObject == null) {
                    return false;
                }
                return ((Comparable)leftObject).compareTo(rightObject) >= 0;
            }
            case LESS_THAN_EQUAL: {
                if (null == leftObject || rightObject == null) {
                    return false;
                }
                return ((Comparable)leftObject).compareTo(rightObject) <= 0;
            }
        }
        throw new IllegalArgumentException("Invalid state as no valid filter was provided");
    }

    public static String makePipeString(Pipe pipe, Object ... arguments) {
        String result = pipe.getClass().getSimpleName();
        if (arguments.length > 0) {
            result = result + "(";
            for (Object arg : arguments) {
                result = result + arg + ",";
            }
            result = result.substring(0, result.length() - 1) + ")";
        }
        return result;
    }

    public static PipeFunction createPipeFunction(final Method method) {
        return new PipeFunction(){
            final Method m;
            {
                this.m = method;
            }

            public Object compute(Object argument) {
                try {
                    return this.m.invoke(null, argument);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        };
    }

    public static PipeFunction createPipeFunction(Class clazz, String methodName, Class ... argumentTypes) {
        try {
            return PipeHelper.createPipeFunction(clazz.getMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.INSTANCE;
    }
}

