/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public class AggregatePipe<S>
extends AbstractPipe<S, S>
implements SideEffectPipe<S, Collection> {
    private Collection aggregate;
    private Queue<S> currentObjectQueue = new LinkedList<S>();
    private Queue<List> currentPathQueue = new LinkedList<List>();
    private List currentPath;
    private PipeFunction<S, ?> preAggregateFunction = null;

    public AggregatePipe(Collection aggregate) {
        this.aggregate = aggregate;
    }

    public AggregatePipe(Collection aggregate, PipeFunction<S, ?> preAggregateFunction) {
        this(aggregate);
        this.preAggregateFunction = preAggregateFunction;
    }

    @Override
    protected List getPathToHere() {
        return this.currentPath;
    }

    @Override
    public List getPath() {
        ArrayList<Object> pathElements = new ArrayList<Object>(this.getPathToHere());
        int size = pathElements.size();
        if (size == 0 || pathElements.get(size - 1) != this.currentEnd) {
            pathElements.add(this.currentEnd);
        }
        return pathElements;
    }

    @Override
    protected S processNextStart() {
        while (this.currentObjectQueue.isEmpty()) {
            if (!this.starts.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentObjectQueue.clear();
            this.currentPathQueue.clear();
            while (this.starts.hasNext()) {
                Object s = this.starts.next();
                if (this.preAggregateFunction != null) {
                    this.aggregate.add(this.preAggregateFunction.compute(s));
                } else {
                    this.aggregate.add(s);
                }
                this.currentObjectQueue.add(s);
                this.currentPathQueue.add(super.getPathToHere());
            }
        }
        this.currentPath = this.currentPathQueue.remove();
        return this.currentObjectQueue.remove();
    }

    @Override
    public Collection getSideEffect() {
        return this.aggregate;
    }

    @Override
    public void reset() {
        try {
            this.aggregate = (Collection)this.aggregate.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.currentPath = null;
        this.currentObjectQueue.clear();
        this.currentPathQueue.clear();
        super.reset();
    }
}

