/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.neo4j;

import com.tinkerpop.blueprints.pgm.AutomaticIndex;
import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.IndexableGraph;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.Parameter;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jAutomaticIndex;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jEdge;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jElement;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jIndex;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jVertex;
import com.tinkerpop.blueprints.pgm.impls.neo4j.util.Neo4jEdgeSequence;
import com.tinkerpop.blueprints.pgm.impls.neo4j.util.Neo4jVertexSequence;
import com.tinkerpop.blueprints.pgm.util.AutomaticIndexHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.tooling.GlobalGraphOperations;

public class Neo4jGraph
implements TransactionalGraph,
IndexableGraph {
    private GraphDatabaseService rawGraph;
    private final ThreadLocal<Transaction> tx = new ThreadLocal<Transaction>(){

        @Override
        protected Transaction initialValue() {
            return null;
        }
    };
    private final ThreadLocal<Integer> txBuffer = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private final ThreadLocal<Integer> txCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public Neo4jGraph(String directory) {
        this(directory, null);
    }

    public Neo4jGraph(String directory, Map<String, String> configuration) {
        this(directory, configuration, false);
    }

    public Neo4jGraph(GraphDatabaseService rawGraph) {
        this.rawGraph = rawGraph;
    }

    public Neo4jGraph(GraphDatabaseService rawGraph, boolean fresh) {
        this.rawGraph = rawGraph;
        if (fresh) {
            this.freshLoad();
        }
    }

    protected Neo4jGraph(String directory, Map<String, String> configuration, boolean highAvailabilityMode) {
        if (highAvailabilityMode && configuration == null) {
            throw new IllegalArgumentException("Configuration parameters must be supplied when using HA mode.");
        }
        boolean fresh = !new File(directory).exists();
        try {
            this.rawGraph = null != configuration ? (highAvailabilityMode ? new HighlyAvailableGraphDatabase(directory, configuration) : new EmbeddedGraphDatabase(directory, configuration)) : new EmbeddedGraphDatabase(directory);
            if (fresh) {
                this.freshLoad();
            }
        }
        catch (RuntimeException e) {
            if (this.rawGraph != null) {
                this.rawGraph.shutdown();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.rawGraph != null) {
                this.rawGraph.shutdown();
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void freshLoad() {
        try {
            this.removeVertex(this.getVertex(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createAutomaticIndex("vertices", Neo4jVertex.class, null, new Parameter[0]);
        this.createAutomaticIndex("edges", Neo4jEdge.class, null, new Parameter[0]);
    }

    private boolean isAutomaticIndex(org.neo4j.graphdb.index.Index rawIndex) {
        String type = (String)this.rawGraph.index().getConfiguration(rawIndex).get("_blueprints:type");
        return null != type && type.equals(Index.Type.AUTOMATIC.toString());
    }

    public synchronized <T extends Element> Index<T> createManualIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        if (this.rawGraph.index().existsForNodes(indexName) || this.rawGraph.index().existsForRelationships(indexName)) {
            throw new RuntimeException("Index already exists: " + indexName);
        }
        return new Neo4jIndex(indexName, indexClass, this, indexParameters);
    }

    public synchronized <T extends Element> AutomaticIndex<T> createAutomaticIndex(String indexName, Class<T> indexClass, Set<String> keys, Parameter ... indexParameters) {
        if (this.rawGraph.index().existsForNodes(indexName) || this.rawGraph.index().existsForRelationships(indexName)) {
            throw new RuntimeException("Index already exists: " + indexName);
        }
        return new Neo4jAutomaticIndex(indexName, indexClass, this, keys, indexParameters);
    }

    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        if (Vertex.class.isAssignableFrom(indexClass)) {
            if (this.rawGraph.index().existsForNodes(indexName)) {
                if (this.isAutomaticIndex(this.rawGraph.index().forNodes(indexName))) {
                    return new Neo4jAutomaticIndex(indexName, indexClass, this, null, new Parameter[0]);
                }
                return new Neo4jIndex(indexName, indexClass, this, new Parameter[0]);
            }
            if (this.rawGraph.index().existsForRelationships(indexName)) {
                throw new RuntimeException("Can not convert existing " + indexName + " index to a " + indexClass + " index");
            }
            return null;
        }
        if (Edge.class.isAssignableFrom(indexClass)) {
            if (this.rawGraph.index().existsForRelationships(indexName)) {
                if (this.isAutomaticIndex((org.neo4j.graphdb.index.Index)this.rawGraph.index().forRelationships(indexName))) {
                    return new Neo4jAutomaticIndex(indexName, indexClass, this, null, new Parameter[0]);
                }
                return new Neo4jIndex(indexName, indexClass, this, new Parameter[0]);
            }
            if (this.rawGraph.index().existsForNodes(indexName)) {
                throw new RuntimeException("Can not convert existing " + indexName + " index to a " + indexClass + " index");
            }
            return null;
        }
        return null;
    }

    public synchronized void dropIndex(String indexName) {
        try {
            RelationshipIndex relationshipIndex;
            this.autoStartTransaction();
            org.neo4j.graphdb.index.Index nodeIndex = this.rawGraph.index().forNodes(indexName);
            if (nodeIndex.isWriteable()) {
                nodeIndex.delete();
            }
            if ((relationshipIndex = this.rawGraph.index().forRelationships(indexName)).isWriteable()) {
                relationshipIndex.delete();
            }
            this.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (RuntimeException e) {
            this.stopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.stopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected <T extends Neo4jElement> Iterable<Neo4jAutomaticIndex<T, PropertyContainer>> getAutoIndices(Class<T> indexClass) {
        boolean forVertices = Vertex.class.isAssignableFrom(indexClass);
        String[] names = forVertices ? this.rawGraph.index().nodeIndexNames() : this.rawGraph.index().relationshipIndexNames();
        ArrayList<Neo4jAutomaticIndex<T, PropertyContainer>> indices = new ArrayList<Neo4jAutomaticIndex<T, PropertyContainer>>();
        for (String name : names) {
            if (forVertices) {
                if (!this.isAutomaticIndex(this.rawGraph.index().forNodes(name))) continue;
                indices.add(new Neo4jAutomaticIndex(name, Vertex.class, this, null, new Parameter[0]));
                continue;
            }
            if (!this.isAutomaticIndex((org.neo4j.graphdb.index.Index)this.rawGraph.index().forRelationships(name))) continue;
            indices.add(new Neo4jAutomaticIndex(name, Edge.class, this, null, new Parameter[0]));
        }
        return indices;
    }

    public Iterable<Index<? extends Element>> getIndices() {
        ArrayList<Index<? extends Element>> indices = new ArrayList<Index<? extends Element>>();
        for (String name : this.rawGraph.index().nodeIndexNames()) {
            if (this.isAutomaticIndex(this.rawGraph.index().forNodes(name))) {
                indices.add(new Neo4jAutomaticIndex(name, Vertex.class, this, null, new Parameter[0]));
                continue;
            }
            indices.add(new Neo4jIndex(name, Vertex.class, this, new Parameter[0]));
        }
        for (String name : this.rawGraph.index().relationshipIndexNames()) {
            if (this.isAutomaticIndex((org.neo4j.graphdb.index.Index)this.rawGraph.index().forRelationships(name))) {
                indices.add(new Neo4jAutomaticIndex(name, Edge.class, this, null, new Parameter[0]));
                continue;
            }
            indices.add(new Neo4jIndex(name, Edge.class, this, new Parameter[0]));
        }
        return indices;
    }

    public Vertex addVertex(Object id) {
        try {
            this.autoStartTransaction();
            Neo4jVertex vertex = new Neo4jVertex(this.rawGraph.createNode(), this);
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            return vertex;
        }
        catch (RuntimeException e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Vertex getVertex(Object id) {
        if (null == id) {
            throw new IllegalArgumentException("Element identifier cannot be null");
        }
        try {
            Long longId = id instanceof Long ? (Long)id : Long.valueOf(Double.valueOf(id.toString()).longValue());
            return new Neo4jVertex(this.rawGraph.getNodeById(longId.longValue()), this);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Iterable<Vertex> getVertices() {
        return new Neo4jVertexSequence(GlobalGraphOperations.at((GraphDatabaseService)this.rawGraph).getAllNodes(), this);
    }

    public Iterable<Edge> getEdges() {
        return new Neo4jEdgeSequence(GlobalGraphOperations.at((GraphDatabaseService)this.rawGraph).getAllRelationships(), this);
    }

    public void removeVertex(Vertex vertex) {
        Long id = (Long)vertex.getId();
        Node node = this.rawGraph.getNodeById(id.longValue());
        if (null != node) {
            try {
                AutomaticIndexHelper.removeElement((IndexableGraph)this, (Element)vertex);
                this.autoStartTransaction();
                for (Edge edge : vertex.getInEdges(new String[0])) {
                    ((Relationship)((Neo4jEdge)edge).getRawElement()).delete();
                }
                for (Edge edge : vertex.getOutEdges(new String[0])) {
                    ((Relationship)((Neo4jEdge)edge).getRawElement()).delete();
                }
                node.delete();
                this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            }
            catch (RuntimeException e) {
                this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
                throw e;
            }
            catch (Exception e) {
                this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        try {
            this.autoStartTransaction();
            Node outNode = ((Neo4jVertex)outVertex).getRawVertex();
            Node inNode = ((Neo4jVertex)inVertex).getRawVertex();
            Relationship relationship = outNode.createRelationshipTo(inNode, (RelationshipType)DynamicRelationshipType.withName((String)label));
            Neo4jEdge edge = new Neo4jEdge(relationship, this, true);
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            return edge;
        }
        catch (RuntimeException e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Edge getEdge(Object id) {
        if (null == id) {
            throw new IllegalArgumentException("Element identifier cannot be null");
        }
        try {
            Long longId = id instanceof Long ? (Long)id : Long.valueOf(Double.valueOf(id.toString()).longValue());
            return new Neo4jEdge(this.rawGraph.getRelationshipById(longId.longValue()), this);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void removeEdge(Edge edge) {
        try {
            AutomaticIndexHelper.removeElement((IndexableGraph)this, (Element)edge);
            this.autoStartTransaction();
            ((Relationship)((Neo4jEdge)edge).getRawElement()).delete();
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (RuntimeException e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void startTransaction() {
        if (this.tx.get() != null) {
            throw new RuntimeException("Stop current transaction before starting another");
        }
        this.txCounter.set(0);
        this.tx.set(this.rawGraph.beginTx());
    }

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (null == this.tx.get()) {
            this.txCounter.set(0);
            return;
        }
        if (conclusion == TransactionalGraph.Conclusion.SUCCESS) {
            this.tx.get().success();
        } else {
            this.tx.get().failure();
        }
        this.tx.get().finish();
        this.tx.remove();
        this.txCounter.set(0);
    }

    public int getMaxBufferSize() {
        return this.txBuffer.get();
    }

    public int getCurrentBufferSize() {
        return this.txCounter.get();
    }

    public void setMaxBufferSize(int size) {
        if (null != this.tx.get()) {
            this.tx.get().success();
            this.tx.get().finish();
            this.tx.remove();
        }
        this.txBuffer.set(size);
        this.txCounter.set(0);
    }

    public void shutdown() {
        if (null != this.tx.get()) {
            try {
                this.tx.get().success();
                this.tx.get().finish();
                this.tx.remove();
            }
            catch (TransactionFailureException transactionFailureException) {
                // empty catch block
            }
        }
        this.rawGraph.shutdown();
    }

    public void clear() {
        try {
            this.autoStartTransaction();
            for (Index<? extends Element> index : this.getIndices()) {
                this.dropIndex(index.getIndexName());
            }
            this.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            this.startTransaction();
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)this.rawGraph).getAllNodes()) {
                for (Relationship relationship : node.getRelationships()) {
                    try {
                        relationship.delete();
                    }
                    catch (IllegalStateException e) {}
                }
                try {
                    node.delete();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            this.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            this.autoStartTransaction();
            this.createAutomaticIndex("vertices", Neo4jVertex.class, null, new Parameter[0]);
            this.createAutomaticIndex("edges", Neo4jEdge.class, null, new Parameter[0]);
            this.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (Exception e) {
            this.stopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void autoStartTransaction() {
        if (this.txBuffer.get() > 0 && this.tx.get() == null) {
            this.tx.set(this.rawGraph.beginTx());
            this.txCounter.set(0);
        }
    }

    protected void autoStopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (this.txBuffer.get() > 0) {
            this.txCounter.set(this.txCounter.get() + 1);
            if (conclusion == TransactionalGraph.Conclusion.FAILURE) {
                this.tx.get().failure();
                this.tx.get().finish();
                this.tx.remove();
                this.txCounter.set(0);
            } else if (this.txCounter.get() % this.txBuffer.get() == 0) {
                this.tx.get().success();
                this.tx.get().finish();
                this.tx.remove();
                this.txCounter.set(0);
            }
        }
    }

    public GraphDatabaseService getRawGraph() {
        return this.rawGraph;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.rawGraph.toString());
    }
}

