/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.partition;

import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.PartitionElement;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.PartitionGraph;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.util.PartitionEdgeSequence;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.util.PartitionVertexSequence;

public class PartitionIndex<T extends Element>
implements Index<T> {
    protected Index<T> rawIndex;
    protected PartitionGraph graph;

    public PartitionIndex(Index<T> rawIndex, PartitionGraph graph) {
        this.rawIndex = rawIndex;
        this.graph = graph;
    }

    @Override
    public String getIndexName() {
        return this.rawIndex.getIndexName();
    }

    @Override
    public Class<T> getIndexClass() {
        return this.rawIndex.getIndexClass();
    }

    @Override
    public Index.Type getIndexType() {
        return this.rawIndex.getIndexType();
    }

    @Override
    public long count(String key, Object value) {
        long counter = 0L;
        for (Element element : this.get(key, value)) {
            ++counter;
        }
        return counter;
    }

    @Override
    public void remove(String key, Object value, T element) {
        this.rawIndex.remove(key, value, ((PartitionElement)element).getRawElement());
    }

    @Override
    public void put(String key, Object value, T element) {
        this.rawIndex.put(key, value, ((PartitionElement)element).getRawElement());
    }

    @Override
    public CloseableSequence<T> get(String key, Object value) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new PartitionVertexSequence(this.rawIndex.get(key, value).iterator(), this.graph);
        }
        return new PartitionEdgeSequence(this.rawIndex.get(key, value).iterator(), this.graph);
    }

    public String toString() {
        return StringFactory.indexString(this);
    }
}

