/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.tg;

import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.WrappingCloseableSequence;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TinkerIndex<T extends Element>
implements Index<T>,
Serializable {
    private Map<String, Map<Object, Set<T>>> index = new HashMap<String, Map<Object, Set<T>>>();
    private final String indexName;
    private final Class<T> indexClass;

    public TinkerIndex(String indexName, Class<T> indexClass) {
        this.indexName = indexName;
        this.indexClass = indexClass;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public Class<T> getIndexClass() {
        return this.indexClass;
    }

    @Override
    public Index.Type getIndexType() {
        return Index.Type.MANUAL;
    }

    @Override
    public void put(String key, Object value, T element) {
        Set<T> objects;
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (keyMap == null) {
            keyMap = new HashMap<Object, Set<T>>();
            this.index.put(key, keyMap);
        }
        if (null == (objects = keyMap.get(value))) {
            objects = new HashSet<T>();
            keyMap.put(value, objects);
        }
        objects.add(element);
    }

    @Override
    public CloseableSequence<T> get(String key, Object value) {
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return new WrappingCloseableSequence(new HashSet());
        }
        Set<T> set = keyMap.get(value);
        if (null == set) {
            return new WrappingCloseableSequence(new HashSet());
        }
        return new WrappingCloseableSequence<T>(new LinkedList<T>(set));
    }

    @Override
    public long count(String key, Object value) {
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return 0L;
        }
        Set<T> set = keyMap.get(value);
        if (null == set) {
            return 0L;
        }
        return set.size();
    }

    @Override
    public void remove(String key, Object value, T element) {
        Set<T> objects;
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null != keyMap && null != (objects = keyMap.get(value))) {
            objects.remove(element);
            if (objects.size() == 0) {
                keyMap.remove(value);
            }
        }
    }

    public void removeElement(T element) {
        if (this.indexClass.isAssignableFrom(element.getClass())) {
            for (Map<Object, Set<T>> map : this.index.values()) {
                for (Set<T> set : map.values()) {
                    set.remove(element);
                }
            }
        }
    }

    public String toString() {
        return StringFactory.indexString(this);
    }
}

