/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.tg;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerAutomaticIndex;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerGraph;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class TinkerElement
implements Element,
Serializable {
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected final String id;
    private final int hashCode;
    protected final TinkerGraph graph;

    protected TinkerElement(String id, TinkerGraph graph) {
        this.graph = graph;
        this.id = id;
        this.hashCode = id.hashCode();
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (key.equals("id") || key.equals("label") && this instanceof Edge) {
            throw new RuntimeException(key + " is a reserved property key");
        }
        Object oldValue = this.properties.put(key, value);
        for (TinkerAutomaticIndex index : this.graph.getAutoIndices()) {
            index.autoUpdate(key, value, oldValue, this);
        }
    }

    @Override
    public Object removeProperty(String key) {
        Object oldValue = this.properties.remove(key);
        for (TinkerAutomaticIndex index : this.graph.getAutoIndices()) {
            index.autoRemove(key, oldValue, this);
        }
        return oldValue;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

