/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.paranamer.generator;

import com.thoughtworks.paranamer.generator.Enhancer;
import com.thoughtworks.paranamer.generator.ParanamerGenerator;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class QdoxParanamerGenerator
implements ParanamerGenerator {
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String COMMA = ",";
    private static final String EMPTY = "";
    private static final String BRACKETS = "[]";

    public void processSourcePath(String sourcePath, String outputPath) throws IOException {
        JavaClass[] classes = this.getClassesSortedByName(sourcePath);
        this.processClasses(classes, outputPath);
    }

    private JavaClass[] getClassesSortedByName(String sourcePath) {
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSourceTree(new File(sourcePath));
        Object[] classes = builder.getClasses();
        Arrays.sort(classes);
        return classes;
    }

    public void processClasses(JavaClass[] classes, String outputPath) throws IOException {
        for (JavaClass javaClass : classes) {
            String content = this.addMethods(javaClass.getMethods());
            File f = new File(outputPath, javaClass.getFullyQualifiedName().replace('.', File.separatorChar) + ".class");
            this.makeEnhancer().enhance(f, content);
        }
    }

    public Enhancer makeEnhancer() {
        return new Enhancer();
    }

    private String addMethods(JavaMethod[] methods) {
        Arrays.sort(methods);
        StringBuilder buffer = new StringBuilder();
        for (JavaMethod javaMethod : methods) {
            if (Arrays.asList(javaMethod.getModifiers()).contains("private") || javaMethod.getParameters().length <= 0) continue;
            this.addMethod(buffer, javaMethod);
        }
        return buffer.toString();
    }

    private void addMethod(StringBuilder sb, JavaMethod method) {
        JavaParameter[] parameters = method.getParameters();
        this.formatMethod(sb, method, parameters);
    }

    private void formatMethod(StringBuilder sb, JavaMethod method, JavaParameter[] parameters) {
        String methodName = method.getName();
        if (method.isConstructor()) {
            methodName = "<init>";
        }
        sb.append(methodName).append(SPACE);
        if (parameters.length > 0) {
            this.formatParameterTypes(sb, parameters);
            sb.append(SPACE);
            this.formatParameterNames(sb, parameters);
            sb.append(SPACE);
        }
        sb.append(NEWLINE);
    }

    private void formatParameterNames(StringBuilder sb, JavaParameter[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            sb.append(parameters[i].getName());
            sb.append(this.comma(i, parameters.length));
        }
    }

    private void formatParameterTypes(StringBuilder sb, JavaParameter[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            Type t = parameters[i].getType();
            sb.append(t.getFullyQualifiedName());
            int dimensions = t.getDimensions();
            for (int d = 0; d < dimensions; ++d) {
                sb.append(BRACKETS);
            }
            sb.append(this.comma(i, parameters.length));
        }
    }

    private String comma(int index, int size) {
        return index + 1 < size ? COMMA : EMPTY;
    }
}

