/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.util;

import com.thetransactioncompany.util.PropertyParseException;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyRetriever {
    private Properties props;

    public PropertyRetriever(Properties props) {
        this.props = props;
    }

    public boolean getBoolean(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new PropertyParseException("Invalid boolean property", key, value);
    }

    public boolean getOptBoolean(String key, boolean def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            return def;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new PropertyParseException("Invalid boolean property", key, value);
    }

    public int getInt(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid int property", key, value);
        }
    }

    public int getOptInt(String key, int def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid int property", key);
        }
    }

    public long getLong(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid long property", key, value);
        }
    }

    public long getOptLong(String key, long def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid long property", key, value);
        }
    }

    public float getFloat(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid float property", key, value);
        }
    }

    public float getOptFloat(String key, float def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            return def;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid float property", key, value);
        }
    }

    public double getDouble(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid double property", key, value);
        }
    }

    public double getOptDouble(String key, double def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            return def;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid double property", key, value);
        }
    }

    public String getString(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        return value;
    }

    public String getOptString(String key, String def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public String getEnumString(String key, String[] enums) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        String[] stringArray = enums;
        int n = enums.length;
        int n2 = 0;
        while (n2 < n) {
            String en = stringArray[n2];
            if (en.equalsIgnoreCase(value)) {
                return value;
            }
            ++n2;
        }
        throw new PropertyParseException("Invalid enum string property", key, value);
    }

    public String getOptEnumString(String key, String[] enums, String def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            return def;
        }
        String[] stringArray = enums;
        int n = enums.length;
        int n2 = 0;
        while (n2 < n) {
            String en = stringArray[n2];
            if (en.equalsIgnoreCase(value)) {
                return value;
            }
            ++n2;
        }
        throw new PropertyParseException("Invalid enum string property", key, value);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClass) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum en = enumArray[n2];
            if (en.toString().equalsIgnoreCase(value)) {
                return (T)en;
            }
            ++n2;
        }
        throw new PropertyParseException("Invalid enum property", key, value);
    }

    public <T extends Enum<T>> T getOptEnum(String key, Class<T> enumClass, T def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            return def;
        }
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum en = enumArray[n2];
            if (en.toString().equalsIgnoreCase(value)) {
                return (T)en;
            }
            ++n2;
        }
        throw new PropertyParseException("Invalid enum property", key, value);
    }
}

