/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class CollectionContainerPolicy
extends InterfaceContainerPolicy {
    public CollectionContainerPolicy() {
    }

    public CollectionContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public CollectionContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    public boolean addInto(Object key, Object element, Object container, AbstractSession session) {
        Object elementToAdd = element;
        if (this.elementDescriptor != null) {
            elementToAdd = this.elementDescriptor.getObjectBuilder().wrapObject(element, session);
        }
        try {
            return ((Collection)container).add(elementToAdd);
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotAddElement(element, container, ex1);
        }
        catch (IllegalArgumentException ex2) {
            throw QueryException.cannotAddElement(element, container, ex2);
        }
        catch (UnsupportedOperationException ex3) {
            throw QueryException.cannotAddElement(element, container, ex3);
        }
    }

    public Object buildContainerFromVector(Vector vector, AbstractSession session) {
        if (this.getContainerClass() == vector.getClass() && !this.hasElementDescriptor()) {
            return vector;
        }
        return super.buildContainerFromVector(vector, session);
    }

    public void clear(Object container) {
        try {
            ((Collection)container).clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(container, "clear()");
        }
    }

    protected boolean contains(Object element, Object container) {
        return ((Collection)container).contains(element);
    }

    public Class getInterfaceType() {
        return ClassConstants.Collection_Class;
    }

    public boolean hasOrder() {
        return Helper.classImplementsInterface(this.getContainerClass(), ClassConstants.SortedSet_Class);
    }

    public boolean isValidContainer(Object container) {
        return container instanceof Collection;
    }

    public boolean isCollectionPolicy() {
        return true;
    }

    public Object iteratorFor(Object container) {
        return ((Collection)container).iterator();
    }

    protected boolean removeFrom(Object key, Object element, Object container) {
        try {
            return ((Collection)container).remove(element);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(element, "remove(Object element)");
        }
    }

    public int sizeFor(Object container) {
        return ((Collection)container).size();
    }
}

