/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class IndexNode
extends Node
implements AliasableNode {
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        if (theQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            Expression expression = this.generateExpression(generationContext);
            reportQuery.addAttribute(String.valueOf(this.left.resolveAttribute()) + "Index", expression, Integer.class);
        }
    }

    public Expression generateExpression(GenerationContext context) {
        Expression owningExpression = this.getLeft().generateExpression(context);
        Expression whereClause = owningExpression.index();
        return whereClause;
    }

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        this.left.validate(context);
        if (!this.left.isVariableNode()) {
            throw JPQLException.indexOnlyAllowedOnVariable(context.getQueryInfo(), this.getLine(), this.getColumn(), this.left.getAsString());
        }
        this.setType(typeHelper.getIntType());
    }

    public boolean isAliasableNode() {
        return true;
    }
}

