/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.queries.StoredProcedureCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedPLSQLStoredProcedureQueryMetadata
extends NamedNativeQueryMetadata {
    private List<PLSQLParameterMetadata> m_parameters = new ArrayList<PLSQLParameterMetadata>();
    private String m_procedureName;

    public NamedPLSQLStoredProcedureQueryMetadata() {
        super("<named-plsql-stored-procedure-query>");
    }

    public NamedPLSQLStoredProcedureQueryMetadata(String elementName) {
        super(elementName);
    }

    public NamedPLSQLStoredProcedureQueryMetadata(MetadataAnnotation namedStoredProcedureQuery, MetadataAccessor accessor) {
        super(namedStoredProcedureQuery, accessor);
        Object[] objectArray = (Object[])namedStoredProcedureQuery.getAttributeArray("parameters");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object storedProcedureParameter = objectArray[n2];
            this.m_parameters.add(new PLSQLParameterMetadata((MetadataAnnotation)storedProcedureParameter, accessor));
            ++n2;
        }
        this.m_procedureName = (String)namedStoredProcedureQuery.getAttribute("procedureName");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedPLSQLStoredProcedureQueryMetadata) {
            NamedPLSQLStoredProcedureQueryMetadata query = (NamedPLSQLStoredProcedureQueryMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_parameters, query.getParameters())) {
                return false;
            }
            return this.valuesMatch(this.m_procedureName, query.getProcedureName());
        }
        return false;
    }

    public String getProcedureName() {
        return this.m_procedureName;
    }

    public List<PLSQLParameterMetadata> getParameters() {
        return this.m_parameters;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_parameters, accessibleObject);
    }

    @Override
    public void process(AbstractSession session, ClassLoader loader, MetadataProject project) {
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        for (PLSQLParameterMetadata parameter : this.m_parameters) {
            parameter.process(call, project, false);
        }
        call.setProcedureName(this.m_procedureName);
        Map<String, Object> hints = this.processQueryHints(session);
        if (this.getResultClass().isVoid()) {
            if (this.hasResultSetMapping(session)) {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(this.getResultSetMapping(), (StoredProcedureCall)call, hints, loader, session));
            } else {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(call, hints, loader, session));
            }
        } else {
            session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(MetadataHelper.getClassForName(this.getResultClass().getName(), loader), (StoredProcedureCall)call, hints, loader, session));
        }
    }

    public void setProcedureName(String procedureName) {
        this.m_procedureName = procedureName;
    }

    public void setParameters(List<PLSQLParameterMetadata> parameters) {
        this.m_parameters = parameters;
    }
}

