/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.sessions.AbstractSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionNormalizer {
    protected Expression additionalExpression;
    protected SQLSelectStatement statement;
    protected List<SubSelectExpression> subSelectExpressions;
    protected AbstractSession session;
    protected Map<Expression, Expression> clonedExpressions;

    public ExpressionNormalizer(SQLSelectStatement statement) {
        this.statement = statement;
    }

    public Map<Expression, Expression> getClonedExpressions() {
        return this.clonedExpressions;
    }

    public void setClonedExpressions(Map<Expression, Expression> clonedExpressions) {
        this.clonedExpressions = clonedExpressions;
    }

    public void addAdditionalExpression(Expression theExpression) {
        this.additionalExpression = this.additionalExpression == null ? theExpression : this.additionalExpression.and(theExpression);
    }

    public void addSubSelectExpression(SubSelectExpression subSelectExpression) {
        if (this.subSelectExpressions == null) {
            this.subSelectExpressions = new ArrayList<SubSelectExpression>(4);
        }
        if (!this.subSelectExpressions.contains(subSelectExpression)) {
            this.subSelectExpressions.add(subSelectExpression);
        }
    }

    public Expression getAdditionalExpression() {
        return this.additionalExpression;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public SQLSelectStatement getStatement() {
        return this.statement;
    }

    public boolean encounteredSubSelectExpressions() {
        return this.subSelectExpressions != null;
    }

    public void normalizeSubSelects(Map clonedExpressions) {
        for (SubSelectExpression next : this.subSelectExpressions) {
            next.normalizeSubSelect(this, clonedExpressions);
        }
    }

    public void setAdditionalExpression(Expression additionalExpression) {
        this.additionalExpression = additionalExpression;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setStatement(SQLSelectStatement statement) {
        this.statement = statement;
    }
}

