/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.BaseNetworkHandler;
import com.sun.grizzly.websockets.WebSocketClient;
import com.sun.grizzly.websockets.WebSocketException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ClientNetworkHandler
extends BaseNetworkHandler {
    private Socket socket;
    private OutputStream outputStream;
    private InputStream inputStream;

    protected ClientNetworkHandler() {
    }

    public ClientNetworkHandler(WebSocketClient webSocket) {
        URL url = webSocket.getAddress();
        try {
            if ("ws".equals(url.getProtocol())) {
                this.socket = new Socket(url.getHost(), url.getPort());
            } else if ("wss".equals(url.getProtocol())) {
                this.socket = this.getSSLSocketFactory().createSocket(url.getHost(), url.getPort());
            } else {
                throw new IOException("Unknown schema: " + url.getProtocol());
            }
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void write(byte[] bytes) {
        try {
            this.outputStream.write(bytes);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
    }

    public void shutdown() throws IOException {
        this.socket.close();
    }

    public boolean ready() {
        return this.read() > 0;
    }

    protected int read() {
        try {
            int length;
            int count = this.chunk.getLength();
            if (count < 1) {
                byte[] bytes = new byte[8192];
                while ((count = this.inputStream.read(bytes)) == 8192) {
                    this.chunk.append(bytes, 0, count);
                }
                if (count > 0) {
                    this.chunk.append(bytes, 0, count);
                }
            }
            if ((length = this.chunk.getLength()) <= 0) {
                return count;
            }
            return length;
        }
        catch (IOException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
    }

    public byte get() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            try {
                return (byte)this.chunk.substract();
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    public byte[] get(int count) {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            try {
                byte[] bytes = new byte[count];
                for (int total = 0; total < count; total += this.chunk.substract(bytes, total, count - total)) {
                    if (this.chunk.getLength() >= count) continue;
                    this.read();
                }
                return bytes;
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    private void fill() {
        if (this.chunk.getLength() == 0) {
            this.read();
        }
    }

    public SSLSocketFactory getSSLSocketFactory() throws IOException {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public void close() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("CNH[").append(this.socket == null ? "unconnected" : Integer.valueOf(this.socket.getLocalPort())).append("] {").append(super.toString()).append('}');
        return sb.toString();
    }
}

