/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.service.dataformats;

import com.streamsets.pipeline.api.FileRef;
import com.streamsets.pipeline.api.StageException;
import com.streamsets.pipeline.api.service.dataformats.DataParser;
import com.streamsets.pipeline.api.service.dataformats.DataParserException;
import com.streamsets.pipeline.api.service.dataformats.Errors;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;

public interface DataFormatParserService {
    default public DataParser getParser(String id, byte[] data, int offset, int len) throws DataParserException {
        return this.getParser(id, new ByteArrayInputStream(data, offset, len), "0");
    }

    default public DataParser getParser(String id, byte[] data) throws DataParserException {
        return this.getParser(id, data, 0, data.length);
    }

    default public DataParser getParser(String id, String data) throws DataParserException {
        return this.getParser(id, new StringReader(data));
    }

    default public DataParser getParser(String id, Reader reader) throws DataParserException {
        return this.getParser(id, reader, 0L);
    }

    default public DataParser getParser(File file, String fileOffset) throws DataParserException {
        try {
            return this.getParser(file.getName(), new FileInputStream(file), fileOffset);
        }
        catch (FileNotFoundException e) {
            throw new DataParserException(Errors.DATA_PARSER_00, file.getAbsolutePath(), e.toString(), e);
        }
    }

    public DataParser getParser(String var1, InputStream var2, String var3) throws DataParserException;

    public DataParser getParser(String var1, Reader var2, long var3) throws DataParserException;

    public DataParser getParser(String var1, Map<String, Object> var2, FileRef var3) throws DataParserException;

    public String getCharset();

    public void setStringBuilderPoolSize(int var1);

    public int getStringBuilderPoolSize();

    public boolean isWholeFileFormat();

    public long suggestedWholeFileBufferSize();

    public Double wholeFileRateLimit() throws StageException;

    public boolean isWholeFileChecksumRequired();
}

