/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import com.streamsets.pipeline.api.base.Errors;
import com.streamsets.pipeline.api.impl.TypeSupport;
import com.streamsets.pipeline.api.impl.Utils;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;

public class ZonedDateTimeTypeSupport
extends TypeSupport<ZonedDateTime> {
    @Override
    public ZonedDateTime convert(Object value) {
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        try {
            Utils.checkArgument(value instanceof String, Utils.format(Errors.API_25.getMessage(), value.getClass().getSimpleName(), value));
            return Utils.parseZoned((String)value);
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException(Utils.format(Errors.API_26.getMessage(), value));
        }
    }

    @Override
    public Object create(Object value) {
        return this.clone(value);
    }

    @Override
    public Object get(Object value) {
        return this.clone(value);
    }

    @Override
    public Object clone(Object value) {
        return value;
    }
}

