/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import com.streamsets.pipeline.api.Field;
import com.streamsets.pipeline.api.base.Errors;
import com.streamsets.pipeline.api.impl.ListMapTypeSupport;
import com.streamsets.pipeline.api.impl.TypeSupport;
import com.streamsets.pipeline.api.impl.Utils;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapTypeSupport
extends TypeSupport<Map> {
    @Override
    public Map convert(Object value) {
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new IllegalArgumentException(Utils.format(Errors.API_15.getMessage(), value.getClass().getSimpleName(), value));
    }

    @Override
    public Object convert(Object value, TypeSupport targetTypeSupport) {
        if (targetTypeSupport instanceof MapTypeSupport || targetTypeSupport instanceof ListMapTypeSupport) {
            return value;
        }
        throw new IllegalArgumentException(Utils.format(Errors.API_16.getMessage(), targetTypeSupport));
    }

    @Override
    public Object clone(Object value) {
        Map<String, Field> map = null;
        if (value != null) {
            map = MapTypeSupport.deepCopy((Map)value);
        }
        return map;
    }

    private static Map<String, Field> deepCopy(Map<String, Field> map) {
        LinkedHashMap<String, Field> copy = new LinkedHashMap<String, Field>();
        for (Map.Entry<String, Field> entry : map.entrySet()) {
            String name = entry.getKey();
            Utils.checkNotNull(name, "Map cannot have null keys");
            Utils.checkNotNull(entry.getValue(), Utils.formatL("Map cannot have null values, key '{}'", name));
            copy.put(entry.getKey(), entry.getValue().clone());
        }
        return copy;
    }

    @Override
    public Object create(Object value) {
        return this.clone(value);
    }
}

