/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.ext.io;

import com.streamsets.pipeline.api.ext.io.ProxyReader;
import java.io.IOException;
import java.io.Reader;

public class CountingReader
extends ProxyReader {
    private long pos;
    private long count;
    private long markLimit = 0L;
    private long readAfterMark = 0L;

    public CountingReader(Reader reader) {
        super(reader);
    }

    @Override
    public long skip(long ln) throws IOException {
        long skip = super.skip(ln);
        this.count += skip;
        this.pos += skip;
        this.updateMarkState(skip);
        return skip;
    }

    @Override
    protected void afterRead(int n) {
        if (n != -1) {
            this.count += (long)n;
            this.pos += (long)n;
            this.updateMarkState(n);
        }
    }

    private void updateMarkState(long n) {
        if (this.markLimit > 0L) {
            this.readAfterMark += n;
            if (this.readAfterMark > this.markLimit) {
                this.markLimit = 0L;
                this.readAfterMark = 0L;
            }
        }
    }

    public long getPos() {
        return this.pos;
    }

    public long getCount() {
        return this.count;
    }

    public long resetCount() {
        long tmp = this.count;
        this.count = 0L;
        this.markLimit = 0L;
        this.readAfterMark = 0L;
        return tmp;
    }

    @Override
    public void mark(int idx) throws IOException {
        super.mark(idx);
        this.markLimit = idx;
        this.readAfterMark = 0L;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.count -= this.readAfterMark;
        this.pos -= this.readAfterMark;
    }
}

