/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lokhttp3/internal/platform/Jdk9Platform;", "Lokhttp3/internal/platform/Platform;", "setProtocolMethod", "Ljava/lang/reflect/Method;", "getProtocolMethod", "(Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;)V", "configureTlsExtensions", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "hostname", "", "protocols", "", "Lokhttp3/Protocol;", "getSelectedProtocol", "socket", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "Companion", "okhttp"})
public final class Jdk9Platform
extends Platform {
    @JvmField
    @NotNull
    public final Method setProtocolMethod;
    @JvmField
    @NotNull
    public final Method getProtocolMethod;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkParameterIsNotNull((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkParameterIsNotNull(protocols, (String)"protocols");
        try {
            String[] stringArray;
            void $this$toTypedArray$iv;
            Object[] objectArray;
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            List<String> names = Platform.Companion.alpnProtocolNames(protocols);
            Collection collection = names;
            int n = 0;
            Object[] objectArray2 = objectArray = new Object[1];
            SSLParameters sSLParameters = sslParameters;
            Method method = this.setProtocolMethod;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray[n] = stringArray = stringArray2;
            method.invoke((Object)sSLParameters, objectArray2);
            sslSocket.setSSLParameters(sslParameters);
        }
        catch (IllegalAccessException e) {
            throw (Throwable)((Object)new AssertionError("failed to set SSL parameters", e));
        }
        catch (InvocationTargetException e) {
            throw (Throwable)((Object)new AssertionError("failed to set SSL parameters", e));
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket socket) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
        try {
            String protocol = (String)this.getProtocolMethod.invoke((Object)socket, new Object[0]);
            string = protocol == null || Intrinsics.areEqual((Object)protocol, (Object)"") ? null : string;
        }
        catch (IllegalAccessException e) {
            throw (Throwable)((Object)new AssertionError("failed to get ALPN selected protocol", e));
        }
        catch (InvocationTargetException e) {
            throw (Throwable)((Object)new AssertionError("failed to get ALPN selected protocol", e));
        }
        return string;
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        Intrinsics.checkParameterIsNotNull((Object)sslSocketFactory, (String)"sslSocketFactory");
        throw (Throwable)new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported on JDK 9+");
    }

    public Jdk9Platform(@NotNull Method setProtocolMethod, @NotNull Method getProtocolMethod) {
        Intrinsics.checkParameterIsNotNull((Object)setProtocolMethod, (String)"setProtocolMethod");
        Intrinsics.checkParameterIsNotNull((Object)getProtocolMethod, (String)"getProtocolMethod");
        this.setProtocolMethod = setProtocolMethod;
        this.getProtocolMethod = getProtocolMethod;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/platform/Jdk9Platform$Companion;", "", "()V", "buildIfSupported", "Lokhttp3/internal/platform/Jdk9Platform;", "okhttp"})
    public static final class Companion {
        @Nullable
        public final Jdk9Platform buildIfSupported() {
            Jdk9Platform jdk9Platform;
            try {
                Method setProtocolMethod = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
                Method getProtocolMethod = SSLSocket.class.getMethod("getApplicationProtocol", new Class[0]);
                Method method = setProtocolMethod;
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"setProtocolMethod");
                Method method2 = getProtocolMethod;
                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"getProtocolMethod");
                jdk9Platform = new Jdk9Platform(method, method2);
            }
            catch (NoSuchMethodException _) {
                jdk9Platform = null;
            }
            return jdk9Platform;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

