/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2;

public enum FetchDirectiveKind {
    ChildSrc("child-src"),
    ConnectSrc("connect-src"),
    DefaultSrc("default-src"),
    FontSrc("font-src"),
    FrameSrc("frame-src"),
    ImgSrc("img-src"),
    ManifestSrc("manifest-src"),
    MediaSrc("media-src"),
    ObjectSrc("object-src"),
    PrefetchSrc("prefetch-src"),
    ScriptSrcAttr("script-src-attr"),
    ScriptSrc("script-src"),
    ScriptSrcElem("script-src-elem"),
    StyleSrcAttr("style-src-attr"),
    StyleSrc("style-src"),
    StyleSrcElem("style-src-elem"),
    WorkerSrc("worker-src");

    public final String repr;
    private static FetchDirectiveKind[] ScriptSrcFallback;
    private static FetchDirectiveKind[] ScriptSrcElemFallback;
    private static FetchDirectiveKind[] ScriptSrcAttrFallback;
    private static FetchDirectiveKind[] StyleSrcFallback;
    private static FetchDirectiveKind[] StyleSrcElemFallback;
    private static FetchDirectiveKind[] StyleSrcAttrFallback;
    private static FetchDirectiveKind[] WorkerSrcFallback;
    private static FetchDirectiveKind[] ConnectSrcFallback;
    private static FetchDirectiveKind[] ManifestSrcFallback;
    private static FetchDirectiveKind[] PrefetchSrcFallback;
    private static FetchDirectiveKind[] ObjectSrcFallback;
    private static FetchDirectiveKind[] FrameSrcFallback;
    private static FetchDirectiveKind[] MediaSrcFallback;
    private static FetchDirectiveKind[] FontSrcFallback;
    private static FetchDirectiveKind[] ImgSrcFallback;

    private FetchDirectiveKind(String repr) {
        this.repr = repr;
    }

    public static FetchDirectiveKind fromString(String name) {
        switch (name) {
            case "child-src": {
                return ChildSrc;
            }
            case "connect-src": {
                return ConnectSrc;
            }
            case "default-src": {
                return DefaultSrc;
            }
            case "font-src": {
                return FontSrc;
            }
            case "frame-src": {
                return FrameSrc;
            }
            case "img-src": {
                return ImgSrc;
            }
            case "manifest-src": {
                return ManifestSrc;
            }
            case "media-src": {
                return MediaSrc;
            }
            case "object-src": {
                return ObjectSrc;
            }
            case "prefetch-src": {
                return PrefetchSrc;
            }
            case "script-src-attr": {
                return ScriptSrcAttr;
            }
            case "script-src": {
                return ScriptSrc;
            }
            case "script-src-elem": {
                return ScriptSrcElem;
            }
            case "style-src-attr": {
                return StyleSrcAttr;
            }
            case "style-src": {
                return StyleSrc;
            }
            case "style-src-elem": {
                return StyleSrcElem;
            }
            case "worker-src": {
                return WorkerSrc;
            }
        }
        return null;
    }

    static FetchDirectiveKind[] getFetchDirectiveFallbackList(FetchDirectiveKind directive) {
        switch (directive) {
            case ScriptSrc: {
                return ScriptSrcFallback;
            }
            case ScriptSrcElem: {
                return ScriptSrcElemFallback;
            }
            case ScriptSrcAttr: {
                return ScriptSrcAttrFallback;
            }
            case StyleSrc: {
                return StyleSrcFallback;
            }
            case StyleSrcElem: {
                return StyleSrcElemFallback;
            }
            case StyleSrcAttr: {
                return StyleSrcAttrFallback;
            }
            case WorkerSrc: {
                return WorkerSrcFallback;
            }
            case ConnectSrc: {
                return ConnectSrcFallback;
            }
            case ManifestSrc: {
                return ManifestSrcFallback;
            }
            case PrefetchSrc: {
                return PrefetchSrcFallback;
            }
            case ObjectSrc: {
                return ObjectSrcFallback;
            }
            case FrameSrc: {
                return FrameSrcFallback;
            }
            case MediaSrc: {
                return MediaSrcFallback;
            }
            case FontSrc: {
                return FontSrcFallback;
            }
            case ImgSrc: {
                return ImgSrcFallback;
            }
        }
        throw new IllegalArgumentException("Unknown fetch directive " + (Object)((Object)directive));
    }

    static {
        ScriptSrcFallback = new FetchDirectiveKind[]{ScriptSrc, DefaultSrc};
        ScriptSrcElemFallback = new FetchDirectiveKind[]{ScriptSrcElem, ScriptSrc, DefaultSrc};
        ScriptSrcAttrFallback = new FetchDirectiveKind[]{ScriptSrcAttr, ScriptSrc, DefaultSrc};
        StyleSrcFallback = new FetchDirectiveKind[]{StyleSrc, DefaultSrc};
        StyleSrcElemFallback = new FetchDirectiveKind[]{StyleSrcElem, StyleSrc, DefaultSrc};
        StyleSrcAttrFallback = new FetchDirectiveKind[]{StyleSrcAttr, StyleSrc, DefaultSrc};
        WorkerSrcFallback = new FetchDirectiveKind[]{WorkerSrc, ChildSrc, ScriptSrc, DefaultSrc};
        ConnectSrcFallback = new FetchDirectiveKind[]{ConnectSrc, DefaultSrc};
        ManifestSrcFallback = new FetchDirectiveKind[]{ManifestSrc, DefaultSrc};
        PrefetchSrcFallback = new FetchDirectiveKind[]{PrefetchSrc, DefaultSrc};
        ObjectSrcFallback = new FetchDirectiveKind[]{ObjectSrc, DefaultSrc};
        FrameSrcFallback = new FetchDirectiveKind[]{FrameSrc, ChildSrc, DefaultSrc};
        MediaSrcFallback = new FetchDirectiveKind[]{MediaSrc, DefaultSrc};
        FontSrcFallback = new FetchDirectiveKind[]{FontSrc, DefaultSrc};
        ImgSrcFallback = new FetchDirectiveKind[]{ImgSrc, DefaultSrc};
    }
}

