/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.apache.commons.lang3.ObjectUtils;

public class SsoTokenRequest {
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="target")
    private TargetEnum target = null;

    public SsoTokenRequest id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="2333323", required=true, value="Id of the sub-account organization")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SsoTokenRequest email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="vipin+subaccount@sendinblue.com", value="User email of sub-account organization")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public SsoTokenRequest target(TargetEnum target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="contacts", value="Set target after login success * automation - Redirect to Automation after login * email_campaign - Redirect to Email Campaign after login * contacts - Redirect to Contacts after login * landing_pages - Redirect to Landing Pages after login * email_transactional - Redirect to Email Transactional after login * senders - Redirect to Contacts after login * sms_campaign - Redirect to Sms Campaign after login * sms_transactional - Redirect to Sms Transactional after login ")
    public TargetEnum getTarget() {
        return this.target;
    }

    public void setTarget(TargetEnum target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsoTokenRequest ssoTokenRequest = (SsoTokenRequest)o;
        return ObjectUtils.equals((Object)this.id, (Object)ssoTokenRequest.id) && ObjectUtils.equals((Object)this.email, (Object)ssoTokenRequest.email) && ObjectUtils.equals((Object)((Object)this.target), (Object)((Object)ssoTokenRequest.target));
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.id, this.email, this.target});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SsoTokenRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    target: ").append(this.toIndentedString((Object)this.target)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TargetEnum {
        AUTOMATION("automation"),
        EMAIL_CAMPAIGN("email_campaign"),
        CONTACTS("contacts"),
        LANDING_PAGES("landing_pages"),
        EMAIL_TRANSACTIONAL("email_transactional"),
        SENDERS("senders"),
        SMS_CAMPAIGN("sms_campaign"),
        SMS_TRANSACTIONAL("sms_transactional");

        private String value;

        private TargetEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TargetEnum fromValue(String text) {
            for (TargetEnum b : TargetEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TargetEnum> {
            public void write(JsonWriter jsonWriter, TargetEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TargetEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TargetEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

