/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.apache.commons.lang3.ObjectUtils;
import sibModel.ConversationsMessageFile;

@ApiModel(description="a Conversations message")
public class ConversationsMessage {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="visitorId")
    private String visitorId = null;
    @SerializedName(value="agentId")
    private String agentId = null;
    @SerializedName(value="agentName")
    private String agentName = null;
    @SerializedName(value="createdAt")
    private Long createdAt = null;
    @SerializedName(value="isPushed")
    private Boolean isPushed = null;
    @SerializedName(value="receivedFrom")
    private String receivedFrom = null;
    @SerializedName(value="file")
    private ConversationsMessageFile file = null;

    public ConversationsMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="eYBEm3gq3zc5ayE2g", value="Message ID. It can be used for further manipulations with the message.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConversationsMessage type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="agent", value="`\"agent\"` for agents\u2019 messages, `\"visitor\"` for visitors\u2019 messages.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ConversationsMessage text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="Good morning! How can I help you?", value="Message text or name of the attached file")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ConversationsMessage visitorId(String visitorId) {
        this.visitorId = visitorId;
        return this;
    }

    @ApiModelProperty(example="kZMvWhf8npAu3H6qd57w2Hv6nh6rnxvg", value="visitor\u2019s ID")
    public String getVisitorId() {
        return this.visitorId;
    }

    public void setVisitorId(String visitorId) {
        this.visitorId = visitorId;
    }

    public ConversationsMessage agentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @ApiModelProperty(example="d9nKoegKSjmCtyK78", value="ID of the agent on whose behalf the message was sent (only in messages sent by an agent).")
    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public ConversationsMessage agentName(String agentName) {
        this.agentName = agentName;
        return this;
    }

    @ApiModelProperty(example="Liz", value="Agent\u2019s name as displayed to the visitor. Only in the messages sent by an agent.")
    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public ConversationsMessage createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="1470222622433", value="Timestamp in milliseconds.")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public ConversationsMessage isPushed(Boolean isPushed) {
        this.isPushed = isPushed;
        return this;
    }

    @ApiModelProperty(example="true", value="`true` for pushed messages")
    public Boolean isIsPushed() {
        return this.isPushed;
    }

    public void setIsPushed(Boolean isPushed) {
        this.isPushed = isPushed;
    }

    public ConversationsMessage receivedFrom(String receivedFrom) {
        this.receivedFrom = receivedFrom;
        return this;
    }

    @ApiModelProperty(example="SuperAwesomeHelpdesk", value="In two-way integrations, messages sent via REST API can be marked with receivedFrom property and then filtered out when received in a webhook to avoid infinite loop.")
    public String getReceivedFrom() {
        return this.receivedFrom;
    }

    public void setReceivedFrom(String receivedFrom) {
        this.receivedFrom = receivedFrom;
    }

    public ConversationsMessage file(ConversationsMessageFile file) {
        this.file = file;
        return this;
    }

    @ApiModelProperty(value="")
    public ConversationsMessageFile getFile() {
        return this.file;
    }

    public void setFile(ConversationsMessageFile file) {
        this.file = file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationsMessage conversationsMessage = (ConversationsMessage)o;
        return ObjectUtils.equals((Object)this.id, (Object)conversationsMessage.id) && ObjectUtils.equals((Object)((Object)this.type), (Object)((Object)conversationsMessage.type)) && ObjectUtils.equals((Object)this.text, (Object)conversationsMessage.text) && ObjectUtils.equals((Object)this.visitorId, (Object)conversationsMessage.visitorId) && ObjectUtils.equals((Object)this.agentId, (Object)conversationsMessage.agentId) && ObjectUtils.equals((Object)this.agentName, (Object)conversationsMessage.agentName) && ObjectUtils.equals((Object)this.createdAt, (Object)conversationsMessage.createdAt) && ObjectUtils.equals((Object)this.isPushed, (Object)conversationsMessage.isPushed) && ObjectUtils.equals((Object)this.receivedFrom, (Object)conversationsMessage.receivedFrom) && ObjectUtils.equals((Object)this.file, (Object)conversationsMessage.file);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.id, this.type, this.text, this.visitorId, this.agentId, this.agentName, this.createdAt, this.isPushed, this.receivedFrom, this.file});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationsMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    visitorId: ").append(this.toIndentedString(this.visitorId)).append("\n");
        sb.append("    agentId: ").append(this.toIndentedString(this.agentId)).append("\n");
        sb.append("    agentName: ").append(this.toIndentedString(this.agentName)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    isPushed: ").append(this.toIndentedString(this.isPushed)).append("\n");
        sb.append("    receivedFrom: ").append(this.toIndentedString(this.receivedFrom)).append("\n");
        sb.append("    file: ").append(this.toIndentedString(this.file)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        AGENT("agent"),
        VISITOR("visitor");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

