/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.impl.ValidatorUtil;
import com.sdicons.json.validator.impl.predicates.Predicate;
import java.util.List;

public class Enumeration
extends Predicate {
    private List<JSONValue> enumValues;

    public Enumeration(String aName, JSONObject aRule) throws ValidationException {
        super(aName, aRule);
        ValidatorUtil.requiresAttribute(aRule, "values", JSONArray.class);
        this.enumValues = ((JSONArray)aRule.get("values")).getValue();
    }

    public void validate(JSONValue aValue) throws ValidationException {
        if (!this.enumValues.contains(aValue)) {
            this.fail("The enumeration does not contain the value.", aValue);
        }
    }
}

